/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiServiceAction;
import java.io.File;
import java.util.Locale;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;

public class VradiServiceConfiguration
extends ApplicationConfig {
    private static final Log log = LogFactory.getLog(VradiServiceConfiguration.class);
    public static final int STEP_AFTER_INIT = 0;
    protected static VradiServiceConfiguration instance = null;
    public static final String DATA_DEFAULT_DIR = "${user.home}" + File.separator + ".vradi" + File.separator + "vradi-${application.version}";
    public static final String ATTACHEMENTS_DEFAULT_DIR_NAME = "attachments";
    public static final String SESSION_ATTACHEMENTS_DEFAULT_DIR_NAME = "sessionAttachments";
    public static final String EMBEDDED_DEFAULT_DIR_NAME = "embeddedFiles";
    public static final String QUERY_HISTORY_DEFAULT_DIR_NAME = "queryHistory";
    public static final String TEMPLATE_DEFAULT_DIR_NAME = "templates";
    public static final String PDF_DEFAULT_DIR_NAME = "pdf";
    public static final String TEMP_DEFAULT_DIR_NAME = "temp";
    public static final String EXPORT_CSV_DEFAULT_DIR_NAME = "exportCSV";
    public static final String IMPORT_CSV_DEFAULT_DIR_NAME = "importCSV";
    public static final String WEB_HARVERT_SCRIPT_DEFAULT_DIR_NAME = "WebHarvestScript";
    public static final String WEB_HARVERT_SCRIPT_PREVIEW_DEFAULT_DIR_NAME = "WebHarvestPreview";

    protected VradiServiceConfiguration() {
        this.loadDefaultOptions(WikittyConfig.WikittyOption.class);
        this.loadDefaultOptions(VradiServiceOption.class);
        this.loadActions(VradiServiceActionDef.class);
    }

    protected void setSystemDefaultProps() {
        String[] datadirs;
        for (String datadir : datadirs = new String[]{"solr.data.dir", "wikitty.searchengine.solr.directory.data", "vradi.objectStore.dir"}) {
            String value = System.getProperty(datadir, null);
            if (value != null) continue;
            value = this.getOption(datadir);
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting system property " + datadir + " : " + value));
            }
            if (value == null) continue;
            System.setProperty(datadir, value);
            this.env.put(datadir, value);
        }
    }

    public static synchronized VradiServiceConfiguration getInstance(String ... args) {
        if (instance == null) {
            try {
                instance = new VradiServiceConfiguration();
                instance.parse(args);
                instance.setSystemDefaultProps();
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't intitialize configuration", (Throwable)ex);
                }
                throw new UnhandledException((Throwable)ex);
            }
        }
        return instance;
    }

    public static enum VradiServiceActionDef implements ApplicationConfig.ActionDef
    {
        HELP(VradiServiceAction.class.getName() + "#help", I18n._((String)"vradi.service.config.help.description"), "-h", "--help"),
        REINDEX_SOLR(VradiServiceAction.class.getName() + "#reIndexSolr", I18n._((String)"vradi.service.config.reIndexSolr.description"), "--reIndexSolr"),
        DELETE_OBSELETE_THESAURUS(VradiServiceAction.class.getName() + "#deleteObseleteThesaurus", I18n._((String)"vradi.service.config.deleteObseleteThesaurus.description"), "--deleteObseleteThesaurus"),
        REINIT_STATUS(VradiServiceAction.class.getName() + "#reinitStatus", I18n._((String)"vradi.service.config.reinitStatus.description"), "--reinitStatus"),
        FORCE_ALL_OLD_USER_ENABLE(VradiServiceAction.class.getName() + "#forceAllOldUserEnable", I18n._((String)"vradi.service.config.forceAllOldUserEnable.description"), "--forceAllOldUserEnable"),
        DELETE_OBSELETE_USERS(VradiServiceAction.class.getName() + "#deleteObseleteUsers", I18n._((String)"vradi.service.config.deleteObseleteUsers.description"), "--deleteObseleteUsers"),
        IMPORT_FILES(VradiServiceAction.class.getName() + "#importFiles", I18n._((String)"vradi.service.config.importFiles.description"), "--importFiles"),
        EXPORT_CLIENTS(VradiServiceAction.class.getName() + "#exportClients", I18n._((String)"vradi.service.config.exportClients.description"), "--exportClients"),
        EXPORT_THESAURUS(VradiServiceAction.class.getName() + "#exportThesaurus", I18n._((String)"vradi.service.config.exportThesaurus.description"), "--exportThesaurus");

        protected String action;
        protected String description;
        protected String[] aliases;

        private VradiServiceActionDef(String action, String description, String ... aliases) {
            this.action = action;
            this.description = description;
            this.aliases = aliases;
        }

        public String getAction() {
            return this.action;
        }

        public String getDescription() {
            return this.action;
        }

        public String[] getAliases() {
            return this.aliases;
        }
    }

    public static enum VradiServiceOption implements ApplicationConfig.OptionDef
    {
        CONFIG_FILE("config.file", I18n._((String)"vradi.service.config.configFileName.description"), "vradi-services.properties", String.class, true, true),
        APPLICATION_VERSION("application.version", I18n._((String)"vradi.service.config.application.version.description"), null, String.class, false, false),
        SERVICE_VERSION("vradi.service.version", I18n._((String)"vradi.service.config.version.description"), null, String.class, false, false),
        DATA_DIR("vradi.data.dir", I18n._((String)"vradi.service.config.data.dir.description"), DATA_DEFAULT_DIR, String.class, false, false),
        LOCALE("vradi.service.locale", I18n._((String)"vradi.service.config.ui.locale.description"), Locale.FRANCE.toString(), Locale.class, false, false),
        MAIL_ADMIN("vradi.mail.admin", I18n._((String)"vradi.service.config.mail.admin.description"), null, String.class, false, false),
        OOO_DIR("oOo.exec.folder", I18n._((String)"vradi.service.config.oOo.exec.folder.description"), "${user.home}/.vradi/vradi-${application.version}", String.class, false, false),
        MAIL_DEBUG("vradi.mail.debug", I18n._((String)"vradi.service.config.mail.debug.description"), Boolean.FALSE.toString(), Boolean.class, false, false),
        SMTP_HOST("vradi.smtp.host", I18n._((String)"vradi.service.config.smtp.host.description"), null, String.class, false, false),
        SMTP_PORT("vradi.smtp.port", I18n._((String)"vradi.service.config.smtp.port.description"), null, Integer.class, false, false),
        IMAP_HOST("vradi.imap.host", I18n._((String)"vradi.service.config.imap.host.description"), null, Integer.class, false, false),
        IMAP_PORT("vradi.imap.port", I18n._((String)"vradi.service.config.imap.port.description"), null, Integer.class, false, false),
        MAIL_USER("vradi.mail.user", I18n._((String)"vradi.service.config.mail.user.description"), null, String.class, false, false),
        MAIL_FROM("vradi.mail.from", I18n._((String)"vradi.service.config.mail.from.description"), null, String.class, false, false),
        MAIL_FROM_NAME("vradi.mail.fromname", I18n._((String)"vradi.service.config.mail.fromname.description"), null, String.class, false, false),
        MAIL_PASSWORD("vradi.mail.password", I18n._((String)"vradi.service.config.mail.password.description"), null, String.class, false, false),
        MAIL_OFFER_SUBJECT("vradi.mail.offer.subject", I18n._((String)"vradi.service.config.mail.offer.subject.description"), null, String.class, false, false),
        SESSION_DEFAULT_PARAGRAPH("vradi.session.defaultParagraph", I18n._((String)"vradi.service.config.session.defaultParagraph.description"), null, String.class, false, false),
        SKIP_MIGRATION("vradi.migration.skip", I18n._((String)"vradi.service.config.migration.skip.description"), Boolean.FALSE.toString(), Boolean.class, false, false),
        ATTACHEMENTS_DIR("vradi.attachments.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("attachments"), String.class, false, false),
        SESSION_ATTACHEMENTS_DIR("vradi.session.attachments.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("sessionAttachments"), String.class, false, false),
        EMBEDDED_DIR("vradi.embeddedFiles.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("embeddedFiles"), String.class, false, false),
        QUERY_HISTORY_DIR("vradi.queryHistory.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("queryHistory"), String.class, false, false),
        TEMPLATE_DIR("vradi.templates.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("templates"), String.class, false, false),
        PDF_DIR("vradi.pdf.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("pdf"), String.class, false, false),
        TEMP_DIR("vradi.temp.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("templates"), String.class, false, false),
        EXPORT_CSV_DIR("vradi.exportCSV.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("exportCSV"), String.class, false, false),
        IMPORT_CSV_DIR("vradi.importCSV.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("importCSV"), String.class, false, false),
        WEB_HARVERT_SCRIPT_DIR("vradi.WebHarvestScript.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("WebHarvestScript"), String.class, false, false),
        WEB_HARVERT_SCRIPT_PREVIEW_DIR("vradi.WebHarvestPreview.dir", I18n._((String)"vradi.service.config.migration.skip.description"), VradiServiceOption.getDefaultDir("WebHarvestPreview"), String.class, false, false);

        public String key;
        public String description;
        public String defaultValue;
        public Class<?> type;
        public boolean isTransient;
        public boolean isFinal;

        private VradiServiceOption(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isFinal = isFinal;
            this.isTransient = isTransient;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isTransient() {
            return this.isTransient;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setTransient(boolean isTransient) {
            this.isTransient = isTransient;
        }

        public void setFinal(boolean isFinal) {
            this.isFinal = isFinal;
        }

        private static String getDefaultDir(String dirName) {
            String defaultDir = "${" + VradiServiceOption.DATA_DIR.key + "}" + File.separator + dirName;
            return defaultDir;
        }
    }
}

