/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.VradiConstants;
import com.jurismarches.vradi.services.FileService;
import com.jurismarches.vradi.services.VradiException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class FileServiceProxy
implements FileService {
    private static final Log log = LogFactory.getLog(FileServiceProxy.class);
    protected String serviceEndpoint;

    public FileServiceProxy(String serviceEndpoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using " + FileServiceProxy.class.getSimpleName() + " to manage file upload"));
        }
        this.serviceEndpoint = serviceEndpoint;
    }

    @Override
    public String uploadTemplate(File file, String extensionName) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.TEMPLATE.toString(), extensionName);
        return this.uploadFile(file, postUrl);
    }

    @Override
    public String uploadWebHarvestScript(File file) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.WEB_HARVEST.toString(), file.getName());
        return this.uploadFile(file, postUrl);
    }

    @Override
    public String uploadFormAttachment(File file, String formId) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.ATTACHMENTS_FORM_FILES.toString(), formId, file.getName());
        return this.uploadFile(file, postUrl);
    }

    @Override
    public String uploadSessionAttachment(File file, String sessionId) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.ATTACHMENTS_SESSION_FILES.toString(), sessionId, file.getName());
        return this.uploadFile(file, postUrl);
    }

    @Override
    public String uploadTempFile(File file) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.TEMP_FILE.toString(), file.getName());
        return this.uploadFile(file, postUrl);
    }

    @Override
    public String uploadFormEmbeddedFile(File file, String formId) throws VradiException {
        String postUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.EMBEDDED_FORM_FILES.toString(), formId, file.getName());
        return this.uploadFile(file, postUrl);
    }

    protected String buildUrl(String endpoint, boolean convertUrl, String ... additionalParams) throws VradiException {
        StringBuilder url = new StringBuilder(endpoint);
        if (url.lastIndexOf("/") == url.length() - 1) {
            url = url.delete(url.length() - 1, url.length());
        }
        for (String additionalParam : additionalParams) {
            url.append("/");
            if (convertUrl) {
                try {
                    additionalParam = URLEncoder.encode(additionalParam, "UTF-8");
                }
                catch (UnsupportedEncodingException eee) {
                    throw new VradiException("Cant parse param '" + additionalParam + "'", eee);
                }
            }
            url.append(additionalParam);
        }
        String urlAsString = url.toString();
        return urlAsString;
    }

    protected String uploadFile(File file, String postUrl) throws VradiException {
        String uri;
        try {
            HttpClientParams params = new HttpClientParams();
            params.setConnectionManagerTimeout(8000L);
            HttpClient client = new HttpClient(params);
            PostMethod postMethod = new PostMethod(postUrl);
            final String filename = file.getName();
            Part[] parts = new Part[]{new FilePart(filename, file){

                protected void sendDispositionHeader(OutputStream out) throws IOException {
                    super.sendDispositionHeader(out);
                    if (filename != null) {
                        out.write(EncodingUtil.getBytes((String)"; filename=", (String)"UTF-8"));
                        out.write(EncodingUtil.getBytes((String)"\"", (String)"UTF-8"));
                        out.write(EncodingUtil.getBytes((String)filename, (String)"UTF-8"));
                        out.write(EncodingUtil.getBytes((String)"\"", (String)"UTF-8"));
                    }
                }
            }};
            MultipartRequestEntity requestEntity = new MultipartRequestEntity(parts, postMethod.getParams());
            postMethod.setRequestEntity((RequestEntity)requestEntity);
            int response = client.executeMethod((HttpMethod)postMethod);
            if (response != 200) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("File upload servlet response : " + response));
                }
                throw new VradiException(I18n._("File upload failed : server response %d", response));
            }
            Header header = postMethod.getResponseHeader("fileuri");
            if (header == null || StringUtils.isEmpty((String)header.getValue())) {
                if (header != null && log.isErrorEnabled()) {
                    log.error((Object)("Can't read upload response as valid file uri : " + header.getValue()));
                }
                throw new VradiException(I18n._("File upload failed : invalid response"));
            }
            uri = header.getValue();
            postMethod.releaseConnection();
        }
        catch (FileNotFoundException ex) {
            throw new VradiException("Can't upload file", ex);
        }
        catch (HttpException ex) {
            throw new VradiException("Can't upload file", ex);
        }
        catch (IOException ex) {
            throw new VradiException("Can't upload file", ex);
        }
        return uri;
    }

    protected File downloadFile(String fileUrl) throws VradiException {
        File resultFile;
        String[] splited = fileUrl.split("/");
        String fullFileName = splited[splited.length - 1];
        try {
            fullFileName = URLDecoder.decode(fullFileName, "UTF-8");
        }
        catch (UnsupportedEncodingException eee) {
            throw new VradiException("Failled to decode " + fullFileName, eee);
        }
        int posPoint = fullFileName.lastIndexOf(46);
        String fileName = fullFileName.substring(0, posPoint - 1);
        String fileExt = fullFileName.substring(posPoint);
        try {
            resultFile = File.createTempFile(fileName, fileExt);
            resultFile.deleteOnExit();
            URL url = new URL(fileUrl);
            FileUtils.copyURLToFile((URL)url, (File)resultFile);
            if (log.isDebugEnabled()) {
                log.debug((Object)("File downloaded to " + resultFile));
            }
        }
        catch (IOException ex) {
            throw new VradiException("Can't download file", ex);
        }
        return resultFile;
    }

    @Override
    public File downloadWebHarvestScript(String uri) throws VradiException {
        return this.downloadWebHarvestScript(true, uri);
    }

    @Override
    public File downloadWebHarvestScript(boolean convertUrl, String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, convertUrl, VradiConstants.FileType.WEB_HARVEST.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadTemplate(String extensionName, String templateName) throws VradiException {
        return this.downloadTemplate(true, extensionName, templateName);
    }

    @Override
    public File downloadTemplate(boolean convertUrl, String extensionName, String templateName) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, convertUrl, VradiConstants.FileType.TEMPLATE.toString(), extensionName, templateName);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadPDF(String uri) throws VradiException {
        return this.downloadPDF(true, uri);
    }

    @Override
    public File downloadPDF(boolean convertUrl, String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, convertUrl, VradiConstants.FileType.PDF.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public String getPDFUrl(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.PDF.toString(), uri);
        return fileUrl;
    }

    @Override
    public File downloadFormAttachment(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.ATTACHMENTS_FORM_FILES.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadFormAttachment(String fileName, String formId) throws VradiException {
        return this.downloadFormAttachment(true, fileName, formId);
    }

    @Override
    public File downloadFormAttachment(boolean convertUrl, String fileName, String formId) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, convertUrl, VradiConstants.FileType.ATTACHMENTS_FORM_FILES.toString(), formId, fileName);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadSessionAttachment(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.ATTACHMENTS_SESSION_FILES.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadSessionAttachment(String fileName, String sessionId) throws VradiException {
        return this.downloadSessionAttachment(true, fileName, sessionId);
    }

    @Override
    public File downloadSessionAttachment(boolean convertUrl, String fileName, String sessionId) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, convertUrl, VradiConstants.FileType.ATTACHMENTS_SESSION_FILES.toString(), sessionId, fileName);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadFormEmbeddedFile(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, false, VradiConstants.FileType.EMBEDDED_FORM_FILES.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public File downloadFormEmbeddedFile(String fileName, String formId) throws VradiException {
        return this.downloadFormEmbeddedFile(true, fileName, formId);
    }

    @Override
    public File downloadFormEmbeddedFile(boolean convertUrl, String fileName, String formId) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, convertUrl, VradiConstants.FileType.EMBEDDED_FORM_FILES.toString(), formId, fileName);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public String getFormEmbeddedUrl(String fileName, String formId) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.EMBEDDED_FORM_FILES.toString(), formId, fileName);
        return fileUrl;
    }

    @Override
    public File downloadRequestHistory(String uri) throws VradiException {
        return this.downloadRequestHistory(true, uri);
    }

    @Override
    public File downloadRequestHistory(boolean convretUrl, String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, convretUrl, VradiConstants.FileType.QUERY_HISTORY.toString(), uri);
        File file = this.downloadFile(fileUrl);
        return file;
    }

    @Override
    public String getRequestHistoryURL(String uri) throws VradiException {
        String fileUrl = this.buildUrl(this.serviceEndpoint, true, VradiConstants.FileType.QUERY_HISTORY.toString(), uri);
        return fileUrl;
    }
}

