/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.managers;

import com.jurismarches.vradi.beans.FormPagedResult;
import com.jurismarches.vradi.beans.QueryBean;
import com.jurismarches.vradi.beans.QueryParameters;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.RootThesaurus;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.ThesaurusManager;
import com.jurismarches.vradi.services.search.CompareFilter;
import com.jurismarches.vradi.services.search.Filter;
import com.jurismarches.vradi.services.search.FilterList;
import com.jurismarches.vradi.services.search.RangeFilter;
import com.jurismarches.vradi.services.search.UnsupportedQueryException;
import com.jurismarches.vradi.services.search.VradiQueryParser;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.DateUtil;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Like;
import org.nuiton.wikitty.search.Search;

public class SearchManager {
    private static final Log log = LogFactory.getLog(SearchManager.class);
    protected WikittyProxy wikittyProxy;
    protected ThesaurusManager thesaurusManager;
    private static final DateFormat frenchDateFormat = DateFormat.getDateInstance(3, Locale.FRANCE);
    private static final DateFormat numericDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.FRANCE);
    private static final Pattern frenchDateFormatPattern = Pattern.compile("^(3[01]|[12][0-9]|0[1-9])/(1[0-2]|0[1-9])/[0-9]{4}$");
    private static final Pattern numericDateFormatPattern = Pattern.compile("^[0-9]{4}(1[0-2]|0[1-9])(3[01]|[12][0-9]|0[1-9])$");
    private static final Pattern uuidPattern = Pattern.compile("^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$");
    private static final Pattern formIdPattern = Pattern.compile("^[0-9]{4}-(1[0-2]|0[1-9])-(3[01]|[12][0-9]|0[1-9])([a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12})$");
    public static final String ALIAS_LAST_MODIFIER = "modificateur";
    public static final String ALIAS_LAST_STATUS_MODIFIER = "modificateur.status";

    public SearchManager(WikittyProxy wikittyProxy, ThesaurusManager thesaurusManager) {
        this.wikittyProxy = wikittyProxy;
        this.thesaurusManager = thesaurusManager;
    }

    protected FormPagedResult findForms(String query, Criteria filter, FormPagedResult formPagedResult) throws UnsupportedQueryException, VradiException {
        FilterList queryParsed = VradiQueryParser.parse(query);
        Search search = Search.query((Criteria)filter);
        this.buildSearch(queryParsed, search);
        Criteria criteria = search.criteria();
        int firstIndex = (formPagedResult.getPageToShow() - 1) * formPagedResult.getNbFormsToShow();
        int lastIndex = formPagedResult.getPageToShow() * formPagedResult.getNbFormsToShow() - 1;
        if (firstIndex >= 0 && lastIndex > 0 && lastIndex > firstIndex) {
            criteria.setFirstIndex(firstIndex).setEndIndex(lastIndex);
        }
        if (formPagedResult.getFieldToSort() != null) {
            if (!formPagedResult.isAscending()) {
                criteria.addSortDescending(formPagedResult.getFieldToSort());
            } else {
                criteria.addSortAscending(formPagedResult.getFieldToSort());
            }
        }
        criteria.addSortAscending("Infogene.id");
        PagedResult queryResult = this.wikittyProxy.findAllByCriteria(Form.class, criteria);
        if (log.isDebugEnabled()) {
            log.debug((Object)("[findForms] found: " + queryResult.size() + " forms"));
        }
        ArrayList<Form> result = new ArrayList<Form>(queryResult.getAll());
        FormPagedResult formPageResult = new FormPagedResult(result, queryResult.getNumFound(), formPagedResult.getPageToShow(), formPagedResult.getNbFormsToShow());
        return formPageResult;
    }

    public FormPagedResult findForms(QueryParameters queryParameters, FormPagedResult formPagedResult) throws UnsupportedQueryException, VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("findForms(query:%s, extension:%s, dateFieldName:%s, beginDate:%tc, endDate:%tc, status:%s)", queryParameters.getQuery(), queryParameters.getExtension(), queryParameters.getDateFieldName(), queryParameters.getBeginDate(), queryParameters.getEndDate(), queryParameters.getStatusIds()));
        }
        Criteria filter = this.createFilter(queryParameters);
        FormPagedResult formPageResult = this.findForms(queryParameters.getQuery(), filter, formPagedResult);
        return formPageResult;
    }

    public Map<Thesaurus, Integer> getChildrenCartography(String thesaurusId, QueryParameters queryParameters) throws VradiException, UnsupportedQueryException {
        Criteria filter = this.createFilter(queryParameters);
        FilterList queryParsed = VradiQueryParser.parse(queryParameters.getQuery());
        Search search = Search.query((Criteria)filter);
        this.buildSearch(queryParsed, search);
        Criteria criteria = search.criteria();
        Map results = this.wikittyProxy.restoreChildren(Thesaurus.class, thesaurusId, criteria);
        return results;
    }

    public Map<Group, List<QueryBean>> findQueriesReturningForm(String formId) throws VradiException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findQueriesReturningForm(formId)");
        }
        Map<Group, List<QueryBean>> results = new HashMap<Group, List<QueryBean>>();
        if (formId == null) {
            return results;
        }
        List<Group> groups = this.findGroupsWithQueries();
        results = this.findQueriesReturningForm(groups, formId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Group found : " + results.size()));
        }
        return results;
    }

    public Map<Group, List<QueryBean>> findQueriesReturningForm(List<Group> groups, String formId) throws VradiException {
        HashMap<Group, List<QueryBean>> results = new HashMap<Group, List<QueryBean>>();
        for (Group group : groups) {
            Set<String> queries = group.getQueries();
            for (String query : queries) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Searching with query : " + query));
                }
                try {
                    QueryBean bean = new QueryBean(query, group.getWikittyId());
                    String realQuery = bean.getQuery();
                    FilterList filter = VradiQueryParser.parse(realQuery);
                    Search search = Search.query();
                    search.eq(Element.ELT_ID, formId);
                    this.buildSearch(filter, search);
                    Criteria criteria = search.criteria();
                    PagedResult forms = this.wikittyProxy.findAllByCriteria(Form.class, criteria);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Search for group " + group.getName() + " return " + forms.getNumFound() + " results : \n\n" + criteria));
                    }
                    if (forms.getNumFound() <= 0) continue;
                    if (results.containsKey(group)) {
                        ((List)results.get(group)).add(bean);
                        continue;
                    }
                    ArrayList<QueryBean> list = new ArrayList<QueryBean>();
                    list.add(bean);
                    results.put(group, list);
                }
                catch (Exception eee) {
                    throw new VradiException("Cant get groups", eee);
                }
            }
        }
        return results;
    }

    public List<Group> findGroupsWithQueries() {
        Criteria criteria = Search.query().bw("QueryMaker.queries", "*", "*").criteria();
        PagedResult pagedResult = this.wikittyProxy.findAllByCriteria(Group.class, criteria);
        List all = pagedResult.getAll();
        return all;
    }

    protected Criteria createFilter(QueryParameters queryParameters) throws UnsupportedQueryException, VradiException {
        Search search = Search.query();
        boolean addedFilter = false;
        if (queryParameters.getExtension() != null) {
            search.eq(Element.ELT_EXTENSION, queryParameters.getExtension().getName());
            addedFilter = true;
        }
        if (queryParameters.getDateFieldName() != null && queryParameters.getBeginDate() != null && queryParameters.getEndDate() != null) {
            String beginString = null;
            String endString = null;
            try {
                beginString = WikittyUtil.formatDate((Date)queryParameters.getBeginDate());
                endString = WikittyUtil.formatDate((Date)queryParameters.getEndDate());
            }
            catch (ParseException eee) {
                throw new VradiException("Cant format date : ", eee);
            }
            search.bw(queryParameters.getDateFieldName(), beginString, endString);
            addedFilter = true;
        }
        if (queryParameters.getThesaurus() != null) {
            for (Thesaurus thesaurus : queryParameters.getThesaurus()) {
                Search subSearch = search.or();
                subSearch.eq("WikittyTreeNode." + thesaurus.getParent(), thesaurus.getWikittyId());
                addedFilter = true;
            }
        }
        if (CollectionUtils.isNotEmpty(queryParameters.getStatusIds())) {
            Search subSearch = search.or();
            for (String statusId : queryParameters.getStatusIds()) {
                subSearch.eq("Infogene.status", statusId);
                addedFilter = true;
            }
        }
        if (queryParameters.getStreamId() != null) {
            search.eq("Form.xmlStream", queryParameters.getStreamId());
            addedFilter = true;
        }
        Criteria criteria = null;
        if (addedFilter) {
            criteria = search.criteria();
        }
        return criteria;
    }

    protected void buildSearch(FilterList list, Search search) throws VradiException {
        FilterList.Operator operator = list.getOperator();
        Search subSearch = null;
        switch (operator) {
            case FILTER_OR: {
                subSearch = search.or();
                break;
            }
            case FILTER_AND: {
                subSearch = search.and();
                break;
            }
            case FILTER_NOT: {
                subSearch = search.not();
            }
        }
        List<Filter> filters = list.getFilters();
        for (Filter filter : filters) {
            if (filter instanceof FilterList) {
                this.buildSearch((FilterList)filter, subSearch);
                continue;
            }
            if (filter instanceof RangeFilter) {
                this.buildRangeSearch((RangeFilter)filter, subSearch);
                continue;
            }
            if (!(filter instanceof CompareFilter)) continue;
            this.buildCompareSearch(operator, (CompareFilter)filter, subSearch);
        }
    }

    protected void buildRangeSearch(RangeFilter rangeFilter, Search search) {
        String name = rangeFilter.getName();
        String lowerValue = rangeFilter.getLowerValue();
        String upperValue = rangeFilter.getUpperValue();
        Search subSearch = search.or();
        if (rangeFilter.match(numericDateFormatPattern)) {
            try {
                Date lowerTime = numericDateFormat.parse(lowerValue);
                lowerTime = DateUtil.setMinTimeOfDay((Date)lowerTime);
                String lowerTimeString = WikittyUtil.formatDate((Date)lowerTime);
                Date upperTime = numericDateFormat.parse(upperValue);
                upperTime = DateUtil.setMaxTimeOfDay((Date)upperTime);
                String upperTimeString = WikittyUtil.formatDate((Date)upperTime);
                subSearch.bw("*." + name + "." + Element.ElementType.DATE, lowerTimeString, upperTimeString);
            }
            catch (ParseException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)(lowerValue + " OR " + upperValue + " cannot be a date."));
                }
            }
        } else if (rangeFilter.isNumber()) {
            subSearch.bw("*." + name + "." + Element.ElementType.NUMERIC, lowerValue, upperValue);
        }
        subSearch.bw("*." + name + "." + Element.ElementType.STRING, lowerValue, upperValue);
    }

    protected void buildCompareSearch(FilterList.Operator operator, CompareFilter compareFilter, Search search) throws VradiException {
        Search subSearch;
        String value;
        String name;
        block21: {
            Date time;
            name = compareFilter.getName();
            value = compareFilter.getValue();
            if ("text".equals(name)) {
                search.keyword(value);
                return;
            }
            List<RootThesaurus> rootThesauruses = this.thesaurusManager.getRootThesaurus();
            for (RootThesaurus rootThesaurus : rootThesauruses) {
                if (!name.equalsIgnoreCase(rootThesaurus.getName())) continue;
                this.buildDescripteurSearch(search, rootThesaurus.getWikittyId(), value);
                return;
            }
            if (ALIAS_LAST_MODIFIER.equals(name)) {
                name = "lastModifier";
            } else if (ALIAS_LAST_STATUS_MODIFIER.equals(name)) {
                name = "lastStatusModifier";
            }
            subSearch = search.or();
            if (operator == FilterList.Operator.FILTER_NOT) {
                if (compareFilter.match(frenchDateFormatPattern)) {
                    try {
                        time = frenchDateFormat.parse(value);
                        String timeString = WikittyUtil.formatDate((Date)time);
                        subSearch.eq("*." + name + "." + Element.ElementType.DATE, timeString);
                    }
                    catch (ParseException e) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)(value + " cannot be a date."));
                        }
                    }
                }
            } else if (compareFilter.match(frenchDateFormatPattern)) {
                try {
                    time = frenchDateFormat.parse(value);
                    Date beginDate = DateUtil.setMinTimeOfDay((Date)time);
                    Date endDate = DateUtil.setMaxTimeOfDay((Date)time);
                    String beginString = WikittyUtil.formatDate((Date)beginDate);
                    String endString = WikittyUtil.formatDate((Date)endDate);
                    subSearch.bw("*." + name + "." + Element.ElementType.DATE, beginString, endString);
                }
                catch (ParseException e) {
                    if (!log.isWarnEnabled()) break block21;
                    log.warn((Object)(value + " cannot be a date."));
                }
            }
        }
        subSearch.like("*." + name + "." + Element.ElementType.STRING, value, Like.SearchAs.AsText);
        if (compareFilter.isBoolean()) {
            subSearch.eq("*." + name + "." + Element.ElementType.BOOLEAN, value);
        } else if (compareFilter.isNumber()) {
            subSearch.eq("*." + name + "." + Element.ElementType.NUMERIC, value);
        } else if (compareFilter.match(formIdPattern)) {
            subSearch.eq("*." + name + "." + Element.ElementType.STRING, value);
        } else if (compareFilter.match(uuidPattern)) {
            subSearch.ew("*." + name + "." + Element.ElementType.STRING, value);
        }
    }

    protected void buildDescripteurSearch(Search search, String rootThesaurusId, String value) {
        Criteria criteria = Search.query().eq("WikittyTreeNode.name", value).eq("Thesaurus.rootThesaurus", rootThesaurusId).eq(Element.ELT_EXTENSION, "Thesaurus").criteria();
        PagedResult queryResult = this.wikittyProxy.findAllByCriteria(Thesaurus.class, criteria);
        if (queryResult.getNumFound() > 0) {
            Search subSearch = search.or();
            List result = queryResult.getAll();
            for (Thesaurus thesaurus : result) {
                if (thesaurus.getParent() == null) {
                    subSearch.eq("WikittyTreeNode.root", thesaurus.getWikittyId());
                    continue;
                }
                subSearch.eq("WikittyTreeNode." + thesaurus.getParent(), thesaurus.getWikittyId());
            }
        }
    }
}

