/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.type.ItemType;

public class RoleLocator
implements Serializable {
    private int kind;
    private Object container;
    private int operand;
    private NamePool namePool;
    private String errorCode = "XPTY0004";
    private SourceLocator sourceLocator;
    public static final int FUNCTION = 0;
    public static final int BINARY_EXPR = 1;
    public static final int TYPE_OP = 2;
    public static final int VARIABLE = 3;
    public static final int INSTRUCTION = 4;
    public static final int FUNCTION_RESULT = 5;
    public static final int ORDER_BY = 6;
    public static final int TEMPLATE_RESULT = 7;

    public RoleLocator(int n, Object object, int n2, NamePool namePool) {
        this.kind = n;
        this.container = object;
        this.operand = n2;
        this.namePool = namePool;
    }

    public void setErrorCode(String string) {
        if (string != null) {
            this.errorCode = string;
        }
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setSourceLocator(SourceLocator sourceLocator) {
        this.sourceLocator = sourceLocator instanceof ExpressionLocation ? sourceLocator : new ExpressionLocation(sourceLocator);
    }

    public SourceLocator getSourceLocator() {
        return this.sourceLocator;
    }

    public String getMessage() {
        String string = this.container instanceof String ? (String)this.container : (this.namePool == null ? "*unknown*" : this.namePool.getDisplayName((Integer)this.container));
        switch (this.kind) {
            case 0: {
                return RoleLocator.ordinal(this.operand + 1) + " argument of " + string + "()";
            }
            case 1: {
                return RoleLocator.ordinal(this.operand + 1) + " operand of '" + string + '\'';
            }
            case 2: {
                return "value in '" + string + "' expression";
            }
            case 3: {
                return "value of variable $" + string;
            }
            case 4: {
                int n = string.indexOf(47);
                String string2 = "";
                if (n >= 0) {
                    string2 = string.substring(n + 1);
                    string = string.substring(0, n);
                }
                return '@' + string2 + " attribute of " + string;
            }
            case 5: {
                return "result of function " + string + "()";
            }
            case 7: {
                return "result of template " + string;
            }
            case 6: {
                return RoleLocator.ordinal(this.operand + 1) + " sort key";
            }
        }
        return "";
    }

    public String composeErrorMessage(ItemType itemType, ItemType itemType2, NamePool namePool) {
        return "Required item type of " + this.getMessage() + " is " + itemType.toString(namePool) + "; supplied value has item type " + itemType2.toString(namePool);
    }

    private static String ordinal(int n) {
        switch (n) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
        }
        return n + "th";
    }
}

