/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.nio.ByteBuffer;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UNICAST2;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class UNICAST_Test {
    Address a1;
    Address a2;
    Vector<Address> members;
    View v;
    Simulator simulator;
    static final int SIZE = 1000;
    static final int NUM_MSGS = 10000;

    @AfterMethod
    void tearDown() throws Exception {
        if (this.simulator != null) {
            this.simulator.stop();
        }
    }

    @Test(dataProvider="configProvider")
    public void testReceptionOfAllMessages(Protocol prot) throws Throwable {
        System.out.println("prot=" + prot.getClass().getSimpleName());
        Protocol[] stack = new Protocol[]{prot};
        this.createStack(stack);
        this._testReceptionOfAllMessages();
    }

    @Test(dataProvider="configProvider")
    public void testReceptionOfAllMessagesWithDISCARD(Protocol prot) throws Throwable {
        System.out.println("prot=" + prot.getClass().getSimpleName());
        DISCARD discard = new DISCARD();
        discard.setDownDiscardRate(0.1);
        Protocol[] stack = new Protocol[]{prot, discard};
        this.createStack(stack);
        this._testReceptionOfAllMessages();
    }

    @DataProvider
    public static Object[][] configProvider() {
        Object[][] retval = new Object[][]{{new UNICAST()}, {new UNICAST2()}};
        ((UNICAST)retval[0][0]).setTimeout(new long[]{500L, 1000L, 2000L, 3000L});
        ((UNICAST2)retval[1][0]).setTimeout(new long[]{500L, 1000L, 2000L, 3000L});
        return retval;
    }

    private static byte[] createPayload(int size, int seqno) {
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.putInt(seqno);
        return buf.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testReceptionOfAllMessages() throws Throwable {
        int num_received = 0;
        Receiver r = new Receiver();
        this.simulator.setReceiver(r);
        for (int i = 1; i <= 10000; ++i) {
            Message msg = new Message(this.a1, null, UNICAST_Test.createPayload(1000, i));
            Event evt = new Event(1, msg);
            this.simulator.send(evt);
            if (i % 1000 != 0) continue;
            System.out.println("==> " + i);
        }
        for (int num_tries = 10; (num_received = r.getNumberOfReceivedMessages()) != 10000 && num_tries > 0; --num_tries) {
            if (r.getException() != null) {
                throw r.getException();
            }
            Receiver receiver = r;
            synchronized (receiver) {
                try {
                    r.wait(3000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                continue;
            }
        }
        this.printStats(num_received);
        Assert.assertEquals((int)num_received, (int)10000);
    }

    private void createStack(Protocol[] stack) throws Exception {
        this.a1 = Util.createRandomAddress();
        this.members = new Vector();
        this.members.add(this.a1);
        this.v = new View(this.a1, 1L, this.members);
        this.simulator = new Simulator();
        this.simulator.setLocalAddress(this.a1);
        this.simulator.setView(this.v);
        this.simulator.addMember(this.a1);
        this.simulator.setProtocolStack(stack);
        this.simulator.start();
    }

    private void printStats(int num_received) {
        System.out.println("-- num received=" + num_received + ", stats:\n" + this.simulator.dumpStats());
    }

    static class Receiver
    implements Simulator.Receiver {
        int num_mgs_received = 0;
        int next = 1;
        Throwable exception = null;
        boolean received_all = false;

        Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Event evt) {
            if (evt.getType() == 1) {
                if (this.exception != null) {
                    return;
                }
                Message msg = (Message)evt.getArg();
                ByteBuffer buf = ByteBuffer.wrap(msg.getRawBuffer());
                int seqno = buf.getInt();
                if (seqno != this.next) {
                    this.exception = new Exception("expected seqno was " + this.next + ", but received " + seqno);
                    return;
                }
                ++this.next;
                ++this.num_mgs_received;
                if (this.num_mgs_received % 1000 == 0) {
                    System.out.println("<== " + this.num_mgs_received);
                }
                if (this.num_mgs_received == 10000) {
                    Receiver receiver = this;
                    synchronized (receiver) {
                        this.received_all = true;
                        this.notifyAll();
                    }
                }
            }
        }

        public int getNumberOfReceivedMessages() {
            return this.num_mgs_received;
        }

        public boolean receivedAll() {
            return this.received_all;
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

