/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services.tasks;

import com.jurismarches.vradi.VradiServiceConfiguration;
import com.jurismarches.vradi.beans.XmlStreamImportResult;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.managers.BindingManager;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Properties;
import java.util.TimerTask;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ExceptionUtil;
import org.nuiton.wikitty.WikittyProxy;

public class ImportXmlStreamTasks
extends TimerTask {
    private static final Log log = LogFactory.getLog(ImportXmlStreamTasks.class);
    protected WikittyProxy wikittyProxy;
    protected BindingManager bindingManager;
    protected String xmlStreamId;

    public ImportXmlStreamTasks(WikittyProxy wikittyProxy, BindingManager bindingManager, String xmlStreamId) {
        this.wikittyProxy = wikittyProxy;
        this.bindingManager = bindingManager;
        this.xmlStreamId = xmlStreamId;
    }

    @Override
    public void run() {
        try {
            XmlStream xmlStream = (XmlStream)this.wikittyProxy.restore(XmlStream.class, this.xmlStreamId);
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting xml stream import on : " + xmlStream.getName() + "..."));
            }
            XmlStreamImportResult importResult = this.bindingManager.importFormsFromXmlStream(xmlStream);
            if (log.isInfoEnabled()) {
                log.info((Object)("Xml stream " + xmlStream.getName() + " imported : " + importResult.getCreatedFormCount() + " new forms."));
            }
        }
        catch (VradiException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Can't import forms from stream " + this.xmlStreamId), (Throwable)eee);
            }
            this.sendEmailError(this.xmlStreamId, eee);
        }
    }

    protected void sendEmailError(String xmlStreamId, VradiException error) {
        log.info((Object)"Error is occured, sending error email");
        XmlStream xmlStream = (XmlStream)this.wikittyProxy.restore(XmlStream.class, xmlStreamId);
        final VradiServiceConfiguration config = VradiServiceConfiguration.getInstance(new String[0]);
        List<String> mailAdmin = config.getMailAdmin();
        for (String email : mailAdmin) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sending error email to " + email));
            }
            if (StringUtils.isBlank((String)email)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Email is empty : " + email));
                }
                return;
            }
            Properties props = new Properties();
            props.put("mail.smtp.host", config.getSmtpHost());
            props.put("mail.smtp.port", (Object)config.getSmtpPort());
            Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(config.getMailUser(), config.getMailPassword());
                }
            });
            MimeMessage msg = new MimeMessage(session);
            try {
                InternetAddress addressFrom = new InternetAddress(config.getMailFrom(), config.getMailFromName());
                msg.setFrom((Address)addressFrom);
                InternetAddress addressTo = new InternetAddress(email);
                msg.addRecipient(Message.RecipientType.TO, (Address)addressTo);
                MimeMultipart multiparts = new MimeMultipart();
                MimeBodyPart msgBodyPart = new MimeBodyPart();
                msgBodyPart.setText(I18n._((String)"vradi.error.errorImportXmlStream", (Object[])new Object[]{xmlStream.getName(), ExceptionUtil.stackTrace(error)}));
                multiparts.addBodyPart((BodyPart)msgBodyPart);
                msg.setContent((Multipart)multiparts);
                msg.setSubject(I18n._((String)"vradi.error.errorImportXmlStream.subject", (Object[])new Object[]{xmlStream.getName()}));
                try {
                    Transport.send((Message)msg);
                }
                catch (MessagingException eee) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Cant send mail", (Throwable)eee);
                }
            }
            catch (MessagingException eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't generate message", (Throwable)eee);
            }
            catch (UnsupportedEncodingException eee) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Can't generate message", (Throwable)eee);
            }
        }
    }
}

