/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi;

import com.jurismarches.vradi.VradiServiceAction;
import java.io.File;
import java.util.Locale;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;

public class VradiServiceConfiguration
extends ApplicationConfig {
    private static final Log log = LogFactory.getLog(VradiServiceConfiguration.class);
    public static final int STEP_AFTER_INIT = 0;
    protected static VradiServiceConfiguration instance = null;

    protected VradiServiceConfiguration() {
        for (Option option : Option.values()) {
            if (option.defaultValue == null) continue;
            this.setDefaultOption(option.key, option.defaultValue);
        }
        for (Enum enum_ : ActionDefinition.values()) {
            for (String alias : ((ActionDefinition)enum_).aliases) {
                this.addActionAlias(alias, ((ActionDefinition)enum_).action);
            }
        }
    }

    public static synchronized VradiServiceConfiguration getInstance(String ... args) {
        if (instance == null) {
            try {
                instance = new VradiServiceConfiguration();
                instance.parse(args);
                instance.setSystemDefaultProps();
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't intitialize configuration", (Throwable)ex);
                }
                throw new UnhandledException((Throwable)ex);
            }
        }
        return instance;
    }

    protected void addActionAlias(String action, String ... aliases) {
        for (String alias : aliases) {
            super.addActionAlias(alias, action);
        }
    }

    public String getApplicationVersion() {
        return this.getOption(Option.APPLICATION_VERSION.key);
    }

    public String getServiceVersion() {
        return this.getOption(Option.SERVICE_VERSION.key);
    }

    public void setServiceVersion(String version) {
        this.setOption(Option.SERVICE_VERSION.key, version);
    }

    public String getDataDir() {
        String option = this.getOption(Option.DATA_DIR.key);
        return option;
    }

    public File getDataDirAsFile() {
        File option = this.getOptionAsFile(Option.DATA_DIR.key);
        return option;
    }

    public Locale getLocale() {
        Locale result = (Locale)this.getOption(Locale.class, Option.LOCALE.key);
        return result;
    }

    public void setLocale(Locale locale) {
        this.setOption(Option.LOCALE.key, locale.toString());
    }

    @Deprecated
    public File getCommonsPropertiesFile() {
        return this.getOptionAsFile("vradi.data.dir", ".vradi-properties");
    }

    public File getAttachmentsDir() {
        return this.getOptionAsFile("vradi.data.dir", "attachments");
    }

    public File getEmbeddedFilesDir() {
        return this.getOptionAsFile("vradi.data.dir", "embeddedFiles");
    }

    public File getQueryHistoryDir() {
        return this.getOptionAsFile("vradi.data.dir", "queryHistory");
    }

    public File getTemplatesDir() {
        return this.getOptionAsFile("vradi.data.dir", "templates");
    }

    public File getPdfDir() {
        return this.getOptionAsFile("vradi.data.dir", "pdf");
    }

    public File getTempDir() {
        return this.getOptionAsFile("vradi.data.dir", "temp");
    }

    public File getWebHarvestPreviewDir() {
        return this.getOptionAsFile("vradi.data.dir", "WebHarvestPreview");
    }

    public File getWebHarvestScriptDir() {
        return this.getOptionAsFile("vradi.data.dir", "WebHarvestScript");
    }

    public String getOpenOfficeExecDir() {
        return this.getOption("oOo.exec.folder");
    }

    public String getSmtpHost() {
        return this.getOption("vradi.smtp.host");
    }

    public int getSmtpPort() {
        return this.getOptionAsInt("vradi.smtp.port");
    }

    public String getImapHost() {
        return this.getOption("vradi.imap.host");
    }

    public int getImapPort() {
        return this.getOptionAsInt("vradi.imap.port");
    }

    public String getMailUser() {
        return this.getOption("vradi.mail.user");
    }

    public String getMailFrom() {
        return this.getOption("vradi.mail.from");
    }

    public String getMailFromName() {
        return this.getOption("vradi.mail.fromname");
    }

    public String getMailPassword() {
        return this.getOption("vradi.mail.password");
    }

    public String getOfferMailSubject() {
        String result = this.getOption("vradi.mail.offer.subject");
        return result;
    }

    public boolean isMailDebug() {
        return this.getOptionAsBoolean("vradi.mail.debug");
    }

    public String getSessionDefaultParagraph() {
        return this.getOption("vradi.session.defaultParagraph");
    }

    public boolean skipMigration() {
        return this.getOptionAsBoolean("vradi.migration.skip");
    }

    public void setWikittyJgroupsChannelName(String channelName) {
        this.setOption(Option.WIKITTY_EVENT_JGROUPCHANNELNAME_OPTION.key, channelName);
    }

    public void setWikittyPropagateEvents(boolean b) {
        this.setOption(Option.WIKITTY_EVENT_PROPAGATE_OPTION.key, String.valueOf(b));
    }

    public void setWikittyListenEvents(boolean b) {
        this.setOption(Option.WIKITTY_CACHE_LISTENEVENTS_OPTION.key, String.valueOf(b));
    }

    public void setWikittyCachePolicy(boolean b) {
        this.setOption(Option.WIKITTY_CACHE_ALLWAYS_RESTORE_COPIES.key, String.valueOf(b));
    }

    protected File getOptionAsFile(String parent, String child) {
        String parentDir = this.getOption(parent);
        File option = new File(parentDir, child);
        return option;
    }

    protected void setSystemDefaultProps() {
        String[] datadirs;
        for (String datadir : datadirs = new String[]{"solr.data.dir", "vradi.objectStore.dir"}) {
            String value = System.getProperty(datadir, null);
            if (value != null) continue;
            value = this.getOption(datadir);
            if (log.isInfoEnabled()) {
                log.info((Object)("Setting system property " + datadir + " : " + value));
            }
            System.setProperty(datadir, value);
            this.env.put(datadir, value);
        }
    }

    public static enum ActionDefinition {
        HELP(VradiServiceAction.class.getName() + "#help", I18n._((String)"vradi.service.config.help.description"), "-h", "--help"),
        REINDEX_SOLR(VradiServiceAction.class.getName() + "#reIndexSolr", I18n._((String)"vradi.service.config.reIndexSolr.description"), "--reIndexSolr"),
        DELETE_OBSELETE_THESAURUS(VradiServiceAction.class.getName() + "#deleteObseleteThesaurus", I18n._((String)"vradi.service.config.deleteObseleteThesaurus.description"), "--deleteObseleteThesaurus"),
        REINIT_STATUS(VradiServiceAction.class.getName() + "#reinitStatus", I18n._((String)"vradi.service.config.reinitStatus.description"), "--reinitStatus"),
        FORCE_ALL_OLD_USER_ENABLE(VradiServiceAction.class.getName() + "#forceAllOldUserEnable", I18n._((String)"vradi.service.config.forceAllOldUserEnable.description"), "--forceAllOldUserEnable"),
        DELETE_OBSELETE_USERS(VradiServiceAction.class.getName() + "#deleteObseleteUsers", I18n._((String)"vradi.service.config.deleteObseleteUsers.description"), "--deleteObseleteUsers");

        protected String action;
        protected String description;
        protected String[] aliases;

        private ActionDefinition(String action, String description, String ... aliases) {
            this.action = action;
            this.description = description;
            this.aliases = aliases;
        }

        public String getAction() {
            return this.action;
        }

        public String getDescription() {
            return this.action;
        }

        public String[] getAliases() {
            return this.aliases;
        }
    }

    public static enum Option {
        CONFIG_FILE("config.file", I18n._((String)"vradi.service.config.configFileName.description"), "vradi-services.properties", String.class, true, true),
        APPLICATION_VERSION("application.version", I18n._((String)"vradi.service.config.application.version.description"), null, String.class, false, false),
        SERVICE_VERSION("vradi.service.version", I18n._((String)"vradi.service.config.version.description"), null, String.class, false, false),
        DATA_DIR("vradi.data.dir", I18n._((String)"vradi.service.config.data.dir.description"), "${user.home}/.vradi/vradi-${application.version}", String.class, false, false),
        LOCALE("vradi.service.locale", I18n._((String)"vradi.service.config.ui.locale"), Locale.FRANCE.toString(), Locale.class, false, false),
        WIKITTY_EVENT_JGROUPCHANNELNAME_OPTION("wikitty.service.event.jgroupschannelname", I18n._((String)"vradi.service.config.wikitty.jgroupschannelname.description"), "wikitty-vradi", Boolean.class, false, false),
        WIKITTY_EVENT_PROPAGATE_OPTION("wikitty.service.event.propagateEvent", I18n._((String)"vradi.service.config.wikitty.propagate.description"), "true", Boolean.class, false, false),
        WIKITTY_CACHE_LISTENEVENTS_OPTION("wikitty.service.cache.listenevents", I18n._((String)"vradi.service.config.listenevents.description"), "true", Boolean.class, false, false),
        WIKITTY_CACHE_ALLWAYS_RESTORE_COPIES("wikitty.service.cache.allwaysRestoreCopies", I18n._((String)"vradi.service.config.cacheusecopies.description"), "true", Boolean.class, false, false);

        public final String key;
        public final String description;
        public final String defaultValue;
        public final Class<?> type;
        public final boolean isTransient;
        public final boolean isFinal;

        private Option(String key, String description, String defaultValue, Class<?> type, boolean isTransient, boolean isFinal) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.type = type;
            this.isFinal = isFinal;
            this.isTransient = isTransient;
        }
    }
}

