/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.lucene.search.BooleanClause;

/**
 * <code>FilterList</code> is an union of <code>Filters</code>
 * which must obey the same <code>FilterList.Operator</code>.
 * 
 * @author $Author: kmorin $
 * @version $Revision: 558 $ $Date: 2010-02-25 14:51:18 +0100 (jeu., 25 févr. 2010) $
 * @since 0.0.4
 */
public class FilterList implements Filter {
    private static final long serialVersionUID = 1L;

    private Operator operator = Operator.MUST_PASS_ALL;
    private List<Filter> filters = new ArrayList<Filter>();

    public static enum Operator {
        MUST_PASS_ALL, MUST_PASS_ONE, MUST_NOT_PASS;
        
        public static Operator getOperator(BooleanClause booleanClause) {
            Operator operator = null;
            
            if (booleanClause != null && booleanClause.isProhibited()) {
                operator = MUST_NOT_PASS;
                
            } else if (booleanClause != null && booleanClause.isRequired()) {
                operator = MUST_PASS_ALL;
                
            } else {
                operator = MUST_PASS_ONE;
            }

            return operator;
        }

        public String getValue() {
            switch(this) {
                case MUST_NOT_PASS: return "NOT";
                case MUST_PASS_ALL: return "AND";
                case MUST_PASS_ONE: return "OR";
            }
            return null;
        }
    }

    public FilterList() {
    }

    public FilterList(Operator operator) {
        this.operator = operator;
    }

    public FilterList(List<Filter> filters) {
        this.filters = filters;
    }

    public FilterList(Operator operator, List<Filter> filters) {
        this.operator = operator;
        this.filters = filters;
    }

    public Operator getOperator() {
        return operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }
    
    public List<Filter> getFilters() {
        return filters;
    }

    public boolean addFilter(Filter filter) {
        return filters.add(filter);
    }

}
