/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.VradiUserBean;

/**
 * @author morin
 *         Date: 7 déc. 2009
 *         Time: 17:34:16
 */
public class VradiVradiUserDTO extends VradiUserBean implements VradiDTO<VradiUser> {

    private static final long serialVersionUID = 1L;

    /**
     * Remplit le bean à partir d'un wikitty.
     *
     * @param wikitty le wikitty source
     */
    @Override
    public void fromWikitty(VradiUser wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setName(wikitty.getName());
            setPassword(wikitty.getPassword());
            setEmail(wikitty.getEmail());
        }
    }

    /**
     * Vide le dto
     */
    @Override
    public void reset() {
        setWikittyId(null);
        setName(null);
        setPassword(null);
        setEmail(null);
    }

    /**
     * Remplit le wikitty à partir du bean.
     *
     * @param wikitty le wikitty a remplir
     */
    @Override
    public void toWikitty(VradiUser wikitty) {
        wikitty.setName(getName());
        wikitty.setPassword(getPassword());
        wikitty.setEmail(getEmail());
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }
}
