/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.jurismarches.vradi.entities.Form;

/**
 * @author morin
 *         Date: 4 déc. 2009
 *         Time: 09:43:37
 */
public class VradiFormPageDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    
    public final static String FORMS_TO_SHOW_PROPERTY = "formsToShow";
    public final static String TOTAL_FOUND_FORM_NB_PROPERTY = "totalFoundFormNb";
    public final static String PAGE_TO_SHOW_PROPERTY = "pageToShow";
    public final static String NB_FORMS_TO_SHOW_PROPERTY = "nbFormsToShow";
    public final static String FIELD_TO_SORT_PROPERTY = "fieldToSort";
    public final static String ASCENDING_PROPERTY = "ascending";

    protected List<Form> formsToShow = new ArrayList<Form>();
    protected int totalFoundFormNb = 0;
    protected int pageToShow = 0;
    protected int nbFormsToShow = 0;
    protected String fieldToSort = null;
    protected boolean ascending = true;

    public VradiFormPageDTO() {
    }

    public VradiFormPageDTO(List<Form> formsToShow) {
        this.formsToShow = formsToShow;
        pageToShow = 0;
        this.totalFoundFormNb = formsToShow.size();
        this.nbFormsToShow = formsToShow.size();
    }

    public VradiFormPageDTO(List<Form> formsToShow, int totalFoundFormNb, int pageToShow, int nbFormsToShow) {
        this.formsToShow = formsToShow;
        this.totalFoundFormNb = totalFoundFormNb;
        this.pageToShow = pageToShow;
        this.nbFormsToShow = nbFormsToShow;
    }

    public List<Form> getFormsToShow() {
        return formsToShow;
    }

    public void setFormsToShow(List<Form> formsToShow) {
        List<? extends Form> oldValue = this.formsToShow;
        this.formsToShow = formsToShow;
        propertyChange.firePropertyChange(FORMS_TO_SHOW_PROPERTY, oldValue, formsToShow);
    }

    public int getTotalFoundFormNb() {
        return totalFoundFormNb;
    }

    public void setTotalFoundFormNb(int totalFoundFormNb) {
        int oldValue = this.totalFoundFormNb;
        this.totalFoundFormNb = totalFoundFormNb;
        propertyChange.firePropertyChange(TOTAL_FOUND_FORM_NB_PROPERTY, oldValue, totalFoundFormNb);
    }

    public int getPageToShow() {
        return pageToShow;
    }

    public void setPageToShow(int pageToShow) {
        int oldValue = this.pageToShow;
        this.pageToShow = pageToShow;
        propertyChange.firePropertyChange(PAGE_TO_SHOW_PROPERTY, oldValue, pageToShow);
    }

    public int getNbFormsToShow() {
        return nbFormsToShow;
    }

    public void setNbFormsToShow(int nbFormsToShow) {
        int oldValue = this.nbFormsToShow;
        this.nbFormsToShow = nbFormsToShow;
        propertyChange.firePropertyChange(NB_FORMS_TO_SHOW_PROPERTY, oldValue, nbFormsToShow);
    }

    public String getFieldToSort() {
        return fieldToSort;
    }

    public void setFieldToSort(String fieldToSort) {
        String oldValue = this.fieldToSort;
        this.fieldToSort = fieldToSort;
        propertyChange.firePropertyChange(FIELD_TO_SORT_PROPERTY, oldValue, fieldToSort);
    }

    public boolean isAscending() {
        return ascending;
    }

    public void setAscending(boolean ascending) {
        boolean oldValue = this.ascending;
        this.ascending = ascending;
        propertyChange.firePropertyChange(ASCENDING_PROPERTY, oldValue, ascending);
    }

    protected transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertyChange.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        propertyChange.removePropertyChangeListener(propertyName, listener);
    }
}
