/*
 * *##% 
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormBean;
import com.jurismarches.vradi.entities.Sending;

import java.util.ArrayList;
import java.util.List;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 23:11:47
 */
public class VradiFormDTO extends FormBean implements VradiDTO<Form> {

    private static final long serialVersionUID = 1L;

    protected List<VradiSendingDTO> sendings = new ArrayList<VradiSendingDTO>();
    
    @Override
    public void fromWikitty(Form wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setDatePeremption(wikitty.getDatePeremption());
            setId(wikitty.getId());
            setObjet(wikitty.getObjet());
            setDatePub(wikitty.getDatePub());
        }
    }

    @Override
    public void reset() {
        setWikittyId(null);
        setDatePeremption(null);
        setId(null);
        setObjet(null);
        setDatePub(null);

    }

    @Override
    public void toWikitty(Form wikitty) {
        wikitty.setDatePeremption(getDatePeremption());
        wikitty.setId(getId());
        wikitty.setObjet(getObjet());
        wikitty.setDatePub(getDatePub());
    }

    @Override
    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    @Override
    public String toString() {
        return getObjet();
    }

    public void addSendingDTO(VradiSendingDTO sending) {
        sendings.add(sending);
    }

    public void addAllSendingDTO(List<VradiSendingDTO> sendings) {
        sendings.addAll(sendings);
    }

    public List<VradiSendingDTO> getSendingDTOs() {
        return sendings;
    }
}
