/*
 * *##%
 * Vradi :: Services
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package com.jurismarches.vradi.services.dto;

import java.util.List;

import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.search.Search;

import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.ServiceFactory;

/**
 * DTO helper to use for non existent impl operation definition.
 * 
 * @author chatellier
 * @version $Revision: 866 $
 * 
 * Last update : $Date: 2010-05-07 11:38:12 +0200 (ven., 07 mai 2010) $
 * By : $Author: chatellier $
 */
public class DTOHelper {

    /**
     * Get users for specified client.
     * 
     * @param clientId client id
     * @return client user list
     * 
     * @deprecated put this in a custom ClientImpl class !
     */
    @Deprecated
    public static List<User> getClientUser(String clientId) {
        WikittyProxy proxy = ServiceFactory.getWikittyProxy();
        
        Criteria criteria = Search.query().eq(User.FQ_FIELD_CLIENT, clientId).criteria();
        List<User> users = proxy.findAllByCriteria(User.class, criteria).getAll();
        return users;
    }
}
