/*
 * *##% 
 * vradi-services
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.UserBean;

import java.util.Date;
import java.util.HashSet;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 22:33:15
 */
public class VradiUserDTO extends UserBean implements VradiDTO<User> {

    private static final long serialVersionUID = 1L;

    public VradiUserDTO() {
        QueryMaker$queries = new HashSet<String>();
    }

    @Override
    public void fromWikitty(User wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setCreationDate(wikitty.getCreationDate());
            setAddress(wikitty.getAddress());
            setEmail(wikitty.getEmail());
            setName(wikitty.getName());
            setPhone(wikitty.getPhone());
            setService(wikitty.getService());
            setValidEmail(wikitty.getValidEmail());

            if (wikitty.getExtensions().contains(ModificationTag.MODIFICATION_TAG)) {
                Object lastModified = wikitty.getField(ModificationTag.EXT_MODIFICATION_TAG,
                        ModificationTag.FIELD_LAST_MODIFIED);
                setLastModified(lastModified != null ? (Date) lastModified : null);
                Object lastModifier = wikitty.getField(ModificationTag.EXT_MODIFICATION_TAG,
                        ModificationTag.FIELD_LAST_MODIFIER);
                setLastModifier(lastModifier != null ? (String) lastModifier : null);
            } else {
                setLastModified(null);
                setLastModifier(null);
            }

            QueryMaker$queries.clear();
            addAllQueries(wikitty.getQueries());
        }
    }

    @Override
    public void reset() {
        setWikittyId(null);
        setCreationDate(null);
        setAddress(null);
        setEmail(null);
        setName(null);
        setPhone(null);
        setService(null);
        setValidEmail(false);
        setLastModified(null);
        setLastModifier(null);
        clearQueries();
    }

    @Override
    public void toWikitty(User wikitty) {
        wikitty.setCreationDate(getCreationDate());
        wikitty.setAddress(getAddress());
        wikitty.setEmail(getEmail());
        wikitty.setName(getName());
        wikitty.setPhone(getPhone());
        wikitty.setService(getService());
        wikitty.setValidEmail(getValidEmail());
        wikitty.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED, getLastModified());
        wikitty.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER, getLastModifier());

        wikitty.clearQueries();
        for (String id : getQueries()) {
            wikitty.addQueries(id);
        }
    }

    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    public Date getLastModified() {
        return (Date) this.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED);
    }

    public void setLastModified(Date lastModified) {
        Date oldValue = getLastModified();
        this.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIED, lastModified);
        propertyChange.firePropertyChange("lastModified", oldValue, lastModified);
    }

    public String getLastModifier() {
        return (String) this.getField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER);
    }

    public void setLastModifier(String lastModifier) {
        String oldValue = getLastModifier();
        this.setField(ModificationTag.EXT_MODIFICATION_TAG, ModificationTag.FIELD_LAST_MODIFIER, lastModifier);
        propertyChange.firePropertyChange("lastModifier", oldValue, lastModifier);
    }

    public void addAllQueries(Iterable<String> element) {
        if (element != null) {
            for (String s : element) {
                QueryMaker$queries.add(s);
            }
        }
        propertyChange.firePropertyChange("queries", null, QueryMaker$queries);
    }
}
