/*
 * *##% 
 * vradi-services
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
package com.jurismarches.vradi.services.dto;

import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormBean;

/**
 * User: chemit
 * Date: 29 oct. 2009
 * Time: 23:11:47
 */
public class VradiFormDTO extends FormBean implements VradiDTO<Form> {

    private static final long serialVersionUID = 1L;

    @Override
    public void fromWikitty(Form wikitty) {
        if (wikitty == null) {
            reset();
        } else {
            setWikittyId(wikitty.getWikittyId());
            setDatePeremption(wikitty.getDatePeremption());
            setId(wikitty.getId());
            setName(wikitty.getName());
            setDatePub(wikitty.getDatePub());
        }
    }

    @Override
    public void reset() {
        setWikittyId(null);
        setDatePeremption(null);
        setId(null);
        setName(null);
        setDatePub(null);

    }

    @Override
    public void toWikitty(Form wikitty) {
        wikitty.setDatePeremption(getDatePeremption());
        wikitty.setId(getId());
        wikitty.setName(getName());
        wikitty.setDatePub(getDatePub());
    }


    public void setWikittyId(String id) {
        String old = this.id;
        this.id = id;
        propertyChange.firePropertyChange("wikittyId", old, id);
    }

    @Override
    public String toString() {
        return getName();
    }
}
