/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.services;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.QueryMaker;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.SendingImpl;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.entities.XmlFieldBinding;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.services.dto.VradiSendingDTO;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;
import org.nuiton.util.MD5;
import org.sharengo.exceptions.TechnicalException;
import org.sharengo.wikitty.BusinessEntity;
import org.sharengo.wikitty.Criteria;
import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.PagedResult;
import org.sharengo.wikitty.TreeNode;
import org.sharengo.wikitty.TreeNodeImpl;
import org.sharengo.wikitty.WikittyExtension;
import org.sharengo.wikitty.WikittyProxy;
import org.sharengo.wikitty.WikittyService;
import org.sharengo.wikitty.WikittyUtil;
import org.sharengo.wikitty.jdbc.WikittyExtensionStorageJDBC;
import org.sharengo.wikitty.jdbc.WikittyServiceJDBC;
import org.sharengo.wikitty.search.Element;
import org.sharengo.wikitty.search.Search;

public class VradiStorageServiceImpl
implements VradiStorageService {
    private static final Log log = LogFactory.getLog(VradiStorageServiceImpl.class);
    protected WikittyProxy proxy;
    protected static String fieldPattern = "[\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)(AND)(OR)]]+:";
    protected static String valuePattern = "[\\p{Graph}\\p{Blank}\\p{L}\\p{Lu}&&[^\\(\\)]]+";
    protected static String notPattern = "(NOT\\p{Blank})?";
    protected static Pattern queryPattern = Pattern.compile("(" + fieldPattern + ")?" + "(" + "\\(" + notPattern + valuePattern + "(" + "\\p{Blank}((AND)|(OR))\\p{Blank}" + notPattern + valuePattern + ")*" + "\\)" + ")" + "(\\p{Blank}((AND)|(OR))\\p{Blank}" + "(" + fieldPattern + ")?" + "(" + "\\(" + notPattern + valuePattern + "(" + "\\p{Blank}((AND)|(OR))\\p{Blank}" + notPattern + valuePattern + ")*" + "\\)" + ")" + ")*?");
    public static String ROOT_THESAURUS_NAME = "Thesaurus";
    protected static String channel = "channel";
    protected static String entry = "entry";
    protected static String feed = "feed";
    protected static String item = "item";
    protected static String rdf = "rdf";
    protected static String defaultFormSendingStatus = "A envoyer";
    public static SimpleDateFormat RSS_DATE_FORMAT = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss Z", Locale.US);
    protected List<String> queriesInTheDB = null;
    Map<Class, Map> cacheMap = new HashMap<Class, Map>();

    public VradiStorageServiceImpl() {
        this.proxy = new WikittyProxy();
        this.proxy.setWikittyService((WikittyService)new WikittyServiceJDBC());
    }

    protected Class initCacheMap(Class clazz) throws TechnicalException {
        if (User.class.isAssignableFrom(clazz)) {
            this.getAllUsers();
            return User.class;
        }
        if (Client.class.isAssignableFrom(clazz)) {
            this.getAllClients();
            return Client.class;
        }
        if (Group.class.isAssignableFrom(clazz)) {
            this.getAllGroups();
            return Group.class;
        }
        if (XmlStream.class.isAssignableFrom(clazz)) {
            this.getAllXmlStreams();
            return XmlStream.class;
        }
        if (TreeNode.class.isAssignableFrom(clazz)) {
            this.getAllThesaurus();
            return TreeNode.class;
        }
        return null;
    }

    @Override
    public BusinessEntity getEntity(String id, Class clazz) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getEntity");
        }
        this.initCacheMap(clazz);
        if (id != null) {
            return (BusinessEntity)this.cacheMap.get(clazz).get(id);
        }
        return null;
    }

    protected List<BusinessEntity> getAllEntities(Class clazz, String ext) {
        if (this.cacheMap.get(clazz) == null) {
            Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, ext).criteria();
            List entities = this.proxy.findAllByCriteria(clazz, criteria).getAll();
            HashMap<String, BusinessEntity> entitiesMap = new HashMap<String, BusinessEntity>();
            for (BusinessEntity entity : entities) {
                entitiesMap.put(entity.getWikittyId(), entity);
            }
            this.cacheMap.put(clazz, entitiesMap);
            return new ArrayList<BusinessEntity>(entities);
        }
        return new ArrayList<BusinessEntity>(this.cacheMap.get(clazz).values());
    }

    @Override
    public BusinessEntity updateEntity(BusinessEntity entity) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateEntity");
        }
        if (entity != null) {
            Set queries;
            if (QueryMaker.class.isAssignableFrom(entity.getClass()) && this.queriesInTheDB != null && (queries = ((QueryMaker)entity).getQueries()) != null) {
                for (String query : queries) {
                    if (this.queriesInTheDB.contains(query)) continue;
                    this.queriesInTheDB.add(query);
                }
            }
            entity.setWikittyVersion(WikittyUtil.incrementMajorRevision((String)entity.getWikittyVersion()));
            BusinessEntity result = this.proxy.store(entity);
            Class clazz = this.initCacheMap(entity.getClass());
            log.debug((Object)clazz);
            log.debug((Object)(this.cacheMap.get(clazz) == null ? 1 : 0));
            this.cacheMap.get(clazz).put(result.getWikittyId(), result);
            return result;
        }
        return null;
    }

    @Override
    public void deleteEntity(BusinessEntity entity) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"deleteEntity");
        }
        if (entity != null) {
            this.proxy.delete(entity.getWikittyId());
            Class clazz = this.initCacheMap(entity.getClass());
            this.cacheMap.get(clazz).remove(entity);
        }
    }

    @Override
    public User getUser(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getUser");
        }
        return (User)this.getEntity(userId, User.class);
    }

    @Override
    public Client getClient(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getClient");
        }
        return (Client)this.getEntity(clientId, Client.class);
    }

    @Override
    public Group getGroup(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroup");
        }
        return (Group)this.getEntity(groupId, Group.class);
    }

    @Override
    public List<User> getGroupUsers(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroupUsers");
        }
        ArrayList<User> result = new ArrayList<User>();
        Group group = this.getGroup(groupId);
        if (group != null) {
            for (String userId : group.getUser()) {
                User user = this.getUser(userId);
                result.add(user);
            }
        }
        return result;
    }

    @Override
    public List<User> getClientUsers(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getClientUsers");
        }
        ArrayList<User> result = new ArrayList<User>();
        Client client = this.getClient(clientId);
        if (client != null && client.getUser() != null) {
            for (String userId : client.getUser()) {
                User user = this.getUser(userId);
                result.add(user);
            }
        }
        return result;
    }

    @Override
    public List<Client> getGroupClients(String groupId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroupClients");
        }
        ArrayList<Client> result = new ArrayList<Client>();
        Group group = this.getGroup(groupId);
        if (group != null && group.getClient() != null) {
            for (String clientId : group.getClient()) {
                Client client = this.getClient(clientId);
                result.add(client);
            }
        }
        return result;
    }

    @Override
    public Client getClientByUserId(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getClientByUserId");
        }
        User user = this.getUser(userId);
        String clientId = user.getClient();
        return this.getClient(clientId);
    }

    @Override
    public List<Group> getGroupsByUserId(String userId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroupsByUserId");
        }
        User user = this.getUser(userId);
        ArrayList groupIds = new ArrayList(user.getGroup());
        ArrayList<Group> result = new ArrayList<Group>();
        for (String groupId : groupIds) {
            result.add(this.getGroup(groupId));
        }
        return result;
    }

    @Override
    public List<Group> getGroupsByClientId(String clientId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getGroupsByClientId");
        }
        Client client = this.getClient(clientId);
        ArrayList groupIds = new ArrayList(client.getGroup());
        ArrayList<Group> result = new ArrayList<Group>();
        for (String groupId : groupIds) {
            result.add(this.getGroup(groupId));
        }
        return result;
    }

    @Override
    public List<Client> getAllClients() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllClients");
        }
        ArrayList<Client> result = new ArrayList<Client>();
        for (BusinessEntity entity : this.getAllEntities(Client.class, "Client")) {
            result.add((Client)entity);
        }
        return result;
    }

    @Override
    public List<User> getAllUsers() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllUsers");
        }
        ArrayList<User> result = new ArrayList<User>();
        for (BusinessEntity entity : this.getAllEntities(User.class, "User")) {
            result.add((User)entity);
        }
        return result;
    }

    @Override
    public List<Group> getAllGroups() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllGroups");
        }
        ArrayList<Group> result = new ArrayList<Group>();
        for (BusinessEntity entity : this.getAllEntities(Group.class, "Group")) {
            result.add((Group)entity);
        }
        return result;
    }

    @Override
    public Form updateForm(Form form) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateForm");
        }
        if (form != null) {
            if (form.getDatePub() == null) {
                form.setDatePub(new Date());
            }
            form.setWikittyVersion(WikittyUtil.incrementMajorRevision((String)form.getWikittyVersion()));
            return (Form)this.proxy.store((BusinessEntity)form);
        }
        return null;
    }

    @Override
    public void deleteForm(String formId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"deleteForm");
        }
        if (formId != null) {
            this.proxy.delete(formId);
        }
    }

    @Override
    public List<Form> findForms(String query) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findForms");
        }
        return this.findForms(query, null, null, null, null, null);
    }

    @Override
    public List<Form> findForms(String query, WikittyExtension extension, String dateType, Date beginDate, Date endDate, List[] thesaurus) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"findForms");
            log.debug((Object)(dateType + " " + beginDate + " - " + endDate + "  : " + extension));
        }
        Search search = Search.query();
        Map<String, String> caught = this.parseQuery(query);
        log.info((Object)query);
        if (caught != null && caught.size() > 1) {
            this.createQuery(search, caught, "_search" + (caught.size() - 1) + "_", null);
        } else if (query != null) {
            String[] tokens = query.split("\\s");
            log.info((Object)tokens.length);
            for (String token : tokens) {
                log.info((Object)token);
                if (token.isEmpty()) continue;
                Search subSearch = search.or();
                subSearch.keyword(token);
                subSearch.keyword(token + "*");
            }
        }
        if (extension != null) {
            search.eq(Element.ELT_EXTENSION, extension.getName());
        }
        if (dateType != null && beginDate != null && endDate != null) {
            log.info((Object)dateType);
            String beginDateS = WikittyUtil.solrDateFormat.format(beginDate);
            String endDateS = WikittyUtil.solrDateFormat.format(endDate);
            if (!beginDate.equals(endDate)) {
                search.bw(dateType, beginDateS, endDateS + "+1DAY");
            } else {
                search.bw(dateType, beginDateS, beginDateS + "+1DAY");
            }
        }
        if (thesaurus != null) {
            for (int i = 0; i < thesaurus.length; ++i) {
                if (thesaurus[i] == null) continue;
                Search subSearch = search.or();
                for (Object th : thesaurus[i]) {
                    subSearch.eq("Form.thesaurus", (String)th);
                }
            }
        }
        Criteria criteria = search.criteria();
        PagedResult result = this.proxy.findAllByCriteria(Form.class, criteria);
        return new ArrayList<Form>(result.getAll());
    }

    @Override
    public List<String> getQueriesReturningForm(Form form) throws TechnicalException {
        ArrayList<String> result = new ArrayList<String>();
        if (this.queriesInTheDB == null) {
            ArrayList<Object> queryMakers = new ArrayList<Object>();
            queryMakers.addAll(this.getAllClients());
            queryMakers.addAll(this.getAllGroups());
            queryMakers.addAll(this.getAllUsers());
            this.queriesInTheDB = new ArrayList<String>();
            for (QueryMaker queryMaker : queryMakers) {
                if (queryMaker.getQueries() == null) continue;
                for (String query : queryMaker.getQueries()) {
                    if (this.queriesInTheDB.contains(query)) continue;
                    this.queriesInTheDB.add(query);
                }
            }
        }
        for (String query : this.queriesInTheDB) {
            Map<String, String> map = this.parseQuery(query);
            if (map == null) continue;
            for (Map.Entry<String, String> stringStringEntry : map.entrySet()) {
                log.info((Object)(stringStringEntry.getKey() + " : " + stringStringEntry.getValue()));
            }
            Boolean formFound = this.isQueryReturningForm(map, "_search" + (map.size() - 1) + "_", null, form);
            if (formFound == null || !formFound.booleanValue()) continue;
            result.add(query);
        }
        return result;
    }

    protected Map<String, String> parseQuery(String query) {
        if (query != null && !query.isEmpty()) {
            String s = query;
            boolean hasMatched = true;
            int k = 0;
            HashMap<String, String> caught = new HashMap<String, String>();
            while (hasMatched) {
                hasMatched = false;
                Matcher m = queryPattern.matcher(s);
                while (m.find()) {
                    hasMatched = true;
                    caught.put("_search" + k + "_", m.group(0).trim());
                    s = s.replace(m.group(0).trim(), "_search" + k++ + "_");
                }
            }
            caught.put("_search" + k + "_", "(" + s + ")");
            return caught;
        }
        return null;
    }

    @Override
    public List<WikittyExtension> getAllFormTypes() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllFormTypes");
        }
        if (this.cacheMap.get(WikittyExtension.class) == null) {
            ArrayList result = new ArrayList();
            WikittyService wikittyService = this.proxy.getWikittyService();
            result.addAll(wikittyService.getAllExtensions(true));
            ArrayList<WikittyExtension> formTypes = new ArrayList<WikittyExtension>();
            HashMap<String, WikittyExtension> extensionMap = new HashMap<String, WikittyExtension>();
            for (WikittyExtension extension : result) {
                if (extension == null || !"Form".equals(extension.getRequires())) continue;
                formTypes.add(extension);
                extensionMap.put(extension.getName(), extension);
            }
            this.cacheMap.put(WikittyExtension.class, extensionMap);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Number of FormType found : " + result.size()));
            }
            return formTypes;
        }
        return new ArrayList<WikittyExtension>(this.cacheMap.get(WikittyExtension.class).values());
    }

    @Override
    public WikittyExtension getFormType(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getFormType");
        }
        if (this.cacheMap.get(WikittyExtension.class) == null) {
            this.getAllFormTypes();
        }
        if (name != null) {
            return (WikittyExtension)this.cacheMap.get(WikittyExtension.class).get(name);
        }
        return null;
    }

    @Override
    public Map<String, FieldType> getFormTypeFields(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getFormTypeFields");
        }
        WikittyExtension ext = this.getFormType(name);
        HashMap<String, FieldType> result = new HashMap<String, FieldType>();
        for (String fieldName : ext.getFieldNames()) {
            result.put(fieldName, ext.getFieldType(fieldName));
        }
        return result;
    }

    @Override
    public WikittyExtension updateFormType(String name, Map<String, FieldType> fields, String requires) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateFormType");
        }
        if (name != null) {
            WikittyExtension result = null;
            WikittyExtension lastVersion = this.getFormType(name);
            if (log.isDebugEnabled()) {
                log.debug((Object)("lastVersion : " + lastVersion));
            }
            result = lastVersion != null ? new WikittyExtension(name, WikittyUtil.incrementMajorRevision((String)lastVersion.getVersion()), requires, (LinkedHashMap)fields) : new WikittyExtension(name, "0.0", requires, (LinkedHashMap)fields);
            List<WikittyExtension> extensions = Arrays.asList(result);
            this.proxy.getWikittyService().storeExtension(extensions);
            if (log.isDebugEnabled()) {
                log.debug((Object)("formType : " + result.getId()));
            }
            this.cacheMap.get(WikittyExtension.class).put(name, result);
            return result;
        }
        return null;
    }

    @Override
    public WikittyExtension updateFormType(WikittyExtension extention) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateFormType");
        }
        LinkedHashMap<String, FieldType> fields = new LinkedHashMap<String, FieldType>();
        for (String fieldName : extention.getFieldNames()) {
            log.debug((Object)fieldName);
            fields.put(fieldName, extention.getFieldType(fieldName));
        }
        return this.updateFormType(extention.getName(), fields, extention.getRequires());
    }

    @Override
    public Form getForm(String formId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getForm");
        }
        Form result = null;
        if (formId != null) {
            result = (Form)this.proxy.restore(Form.class, formId);
        }
        return result;
    }

    @Override
    public List<Form> getForms(List<String> formIds) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getForm");
        }
        List result = null;
        if (formIds != null) {
            result = this.proxy.restore(Form.class, formIds);
        }
        return result;
    }

    @Override
    public List<Form> getAllForms() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllForms");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Form").criteria();
        return new ArrayList<Form>(this.proxy.findAllByCriteria(Form.class, criteria).getAll());
    }

    protected void createQuery(Search search, Map<String, String> caught, String sss, String field) {
        String expression;
        String si;
        if (log.isDebugEnabled()) {
            log.debug((Object)"createQuery");
        }
        if ((si = caught.get(sss)).startsWith("(")) {
            expression = si.substring(1, si.length() - 1);
        } else {
            field = si.substring(0, si.indexOf(":")).replace(" ", WikittyExtensionStorageJDBC.WORD_SEPARATOR);
            expression = si.substring(si.indexOf("(") + 1, si.length() - 1);
        }
        String[] orSplitted = expression.split(" OR ");
        if (orSplitted.length > 1) {
            this.addTokens(search.or(), orSplitted, field, caught);
        } else {
            String[] andSplitted = expression.split(" AND ");
            if (andSplitted.length > 1) {
                this.addTokens(search.and(), andSplitted, field, caught);
            } else {
                this.addTokens(search, new String[]{expression}, field, caught);
            }
        }
    }

    protected void addTokens(Search search, String[] tokens, String field, Map<String, String> caught) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"equalsFieldValue");
        }
        for (String token : tokens) {
            Search subSearch;
            block21: {
                block20: {
                    block19: {
                        if (token.trim().startsWith("NOT ")) {
                            block18: {
                                block17: {
                                    block16: {
                                        subSearch = search.and();
                                        subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.STRING, token.trim().substring(4));
                                        subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.STRING, token.trim().substring(4) + "*");
                                        try {
                                            subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.DATE, WikittyUtil.solrDateFormat.format(DateFormat.getInstance().parse(token.trim().substring(4))));
                                        }
                                        catch (ParseException eee) {
                                            if (!log.isDebugEnabled()) break block16;
                                            log.debug((Object)(token + " cannot be a date."));
                                        }
                                    }
                                    try {
                                        Boolean.parseBoolean(token.trim().substring(4));
                                        subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.BOOLEAN, token.trim().substring(4).toLowerCase());
                                    }
                                    catch (Exception eee) {
                                        if (!log.isDebugEnabled()) break block17;
                                        log.debug((Object)(token + " cannot be a boolean."));
                                    }
                                }
                                try {
                                    Double.valueOf(token.trim().substring(4));
                                    subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.NUMERIC, token.trim().substring(4));
                                }
                                catch (NumberFormatException eee) {
                                    if (!log.isDebugEnabled()) break block18;
                                    log.debug((Object)(token + " cannot be a number."));
                                }
                            }
                            subSearch.neq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.WIKITTY, token.trim().substring(4));
                            continue;
                        }
                        if (caught.containsKey(token.trim())) {
                            this.createQuery(search, caught, token.trim(), field);
                            continue;
                        }
                        subSearch = search.or();
                        subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.STRING, token.trim());
                        subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.STRING, token.trim() + "*");
                        try {
                            GregorianCalendar calendar = new GregorianCalendar();
                            calendar.setTime(DateFormat.getDateInstance(3, Locale.FRANCE).parse(token.trim()));
                            GregorianCalendar beginCal = new GregorianCalendar();
                            beginCal.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                            GregorianCalendar endCal = new GregorianCalendar();
                            endCal.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
                            ((Calendar)endCal).add(5, 1);
                            log.info((Object)(beginCal.getTime() + " - " + endCal.getTime()));
                            subSearch.bw(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.DATE, WikittyUtil.solrDateFormat.format(beginCal.getTime()), WikittyUtil.solrDateFormat.format(endCal.getTime()));
                        }
                        catch (ParseException eee) {
                            if (!log.isDebugEnabled()) break block19;
                            log.debug((Object)(token + " cannot be a date."));
                        }
                    }
                    try {
                        Boolean.parseBoolean(token.trim());
                        subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.BOOLEAN, token.trim());
                    }
                    catch (Exception eee) {
                        if (!log.isDebugEnabled()) break block20;
                        log.debug((Object)(token.toLowerCase() + " cannot be a boolean."));
                    }
                }
                try {
                    Double.valueOf(token.trim());
                    subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.NUMERIC, token.trim());
                }
                catch (NumberFormatException eee) {
                    if (!log.isDebugEnabled()) break block21;
                    log.debug((Object)(token + " cannot be a number."));
                }
            }
            subSearch.eq(Criteria.ALL_EXTENSIONS + Criteria.SEPARATOR + field + Criteria.SEPARATOR + FieldType.TYPE.WIKITTY, token.trim());
        }
    }

    protected Boolean isQueryReturningForm(Map<String, String> caught, String sss, String field, Form form) {
        String[] andSplitted;
        String expression;
        String si;
        if (log.isDebugEnabled()) {
            log.debug((Object)"createQuery");
        }
        if ((si = caught.get(sss)).startsWith("(")) {
            expression = si.substring(1, si.length() - 1);
        } else {
            field = si.substring(0, si.indexOf(":")).replace(" ", WikittyExtensionStorageJDBC.WORD_SEPARATOR);
            expression = si.substring(si.indexOf("(") + 1, si.length() - 1);
        }
        String[] orSplitted = expression.split(" OR ");
        Boolean result = orSplitted.length > 1 ? this.equalsFieldValue(orSplitted, field, caught, form, false) : ((andSplitted = expression.split(" AND ")).length > 1 ? this.equalsFieldValue(andSplitted, field, caught, form, true) : this.equalsFieldValue(new String[]{expression}, field, caught, form, true));
        return result;
    }

    protected Boolean equalsFieldValue(String[] tokens, String field, Map<String, String> caught, Form form, Boolean and) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"equalsFieldValue");
        }
        Boolean result = null;
        HashMap<String, FieldType> extensions = new HashMap<String, FieldType>();
        if (form != null) {
            for (WikittyExtension ext : form.getExtensions()) {
                if (ext.getFieldType(field) == null) continue;
                extensions.put(ext.getName(), ext.getFieldType(field));
            }
        }
        for (String token : tokens) {
            String queryString;
            String formString;
            BigDecimal queryNumber;
            BigDecimal formNumber;
            Boolean queryBoolean;
            Boolean formBoolean;
            Date queryDate;
            Date formDate;
            Boolean tokenResult = null;
            if (token.trim().startsWith("NOT ")) {
                block26: for (String extensionName : extensions.keySet()) {
                    switch (((FieldType)extensions.get(extensionName)).getType()) {
                        case DATE: {
                            formDate = (Date)form.getField(extensionName, field);
                            try {
                                queryDate = DateFormat.getInstance().parse(token.trim().substring(4));
                                tokenResult = !formDate.equals(queryDate);
                            }
                            catch (ParseException eee) {
                                if (!log.isDebugEnabled()) continue block26;
                                log.debug((Object)(token + " cannot be a date."));
                            }
                            break;
                        }
                        case BOOLEAN: {
                            formBoolean = (Boolean)form.getField(extensionName, field);
                            try {
                                queryBoolean = Boolean.parseBoolean(token.trim().substring(4));
                                tokenResult = !formBoolean.equals(queryBoolean);
                            }
                            catch (Exception eee) {
                                if (!log.isDebugEnabled()) continue block26;
                                log.debug((Object)(token + " cannot be a boolean."));
                            }
                            break;
                        }
                        case NUMERIC: {
                            formNumber = (BigDecimal)form.getField(extensionName, field);
                            try {
                                queryNumber = BigDecimal.valueOf(Double.valueOf(token.trim().substring(4)));
                                tokenResult = !formNumber.equals(queryNumber);
                            }
                            catch (NumberFormatException eee) {
                                if (!log.isDebugEnabled()) continue block26;
                                log.debug((Object)(token + " cannot be a number."));
                            }
                            break;
                        }
                        case WIKITTY: {
                            formString = (String)form.getField(extensionName, field);
                            queryString = token.trim().substring(4);
                            tokenResult = !formString.equals(queryString);
                            break;
                        }
                        default: {
                            formString = (String)form.getField(extensionName, field);
                            queryString = token.trim().substring(4);
                            tokenResult = !formString.contains(queryString);
                        }
                    }
                }
            } else if (caught.containsKey(token.trim())) {
                tokenResult = this.isQueryReturningForm(caught, token.trim(), field, form);
            } else {
                block27: for (String extensionName : extensions.keySet()) {
                    switch (((FieldType)extensions.get(extensionName)).getType()) {
                        case DATE: {
                            formDate = (Date)form.getField(extensionName, field);
                            try {
                                queryDate = DateFormat.getInstance().parse(token.trim());
                                tokenResult = formDate.equals(queryDate);
                            }
                            catch (ParseException eee) {
                                if (!log.isDebugEnabled()) continue block27;
                                log.debug((Object)(token + " cannot be a date."));
                            }
                            break;
                        }
                        case BOOLEAN: {
                            formBoolean = (Boolean)form.getField(extensionName, field);
                            try {
                                queryBoolean = Boolean.parseBoolean(token.trim());
                                tokenResult = formBoolean.equals(queryBoolean);
                            }
                            catch (Exception eee) {
                                if (!log.isDebugEnabled()) continue block27;
                                log.debug((Object)(token + " cannot be a boolean."));
                            }
                            break;
                        }
                        case NUMERIC: {
                            formNumber = (BigDecimal)form.getField(extensionName, field);
                            try {
                                queryNumber = BigDecimal.valueOf(Double.valueOf(token.trim()));
                                tokenResult = formNumber.equals(queryNumber);
                            }
                            catch (NumberFormatException eee) {
                                if (!log.isDebugEnabled()) continue block27;
                                log.debug((Object)(token + " cannot be a number."));
                            }
                            break;
                        }
                        case WIKITTY: {
                            formString = (String)form.getField(extensionName, field);
                            queryString = token.trim();
                            tokenResult = formString.equals(queryString);
                            break;
                        }
                        default: {
                            formString = (String)form.getField(extensionName, field);
                            queryString = token.trim();
                            tokenResult = formString.contains(queryString);
                        }
                    }
                }
            }
            result = result == null ? tokenResult : (and != false ? Boolean.valueOf(result != false && tokenResult != false) : Boolean.valueOf(result != false || tokenResult != false));
        }
        return result;
    }

    @Override
    public List<XmlStream> getAllXmlStreams() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllXmlStreams");
        }
        ArrayList<XmlStream> result = new ArrayList<XmlStream>();
        for (BusinessEntity entity : this.getAllEntities(XmlStream.class, "XmlStream")) {
            result.add((XmlStream)entity);
        }
        return result;
    }

    @Override
    public List<XmlFieldBinding> updateXmlFieldBindings(List<XmlFieldBinding> bindings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateXmlFieldBindings");
        }
        if (bindings != null) {
            List<XmlFieldBinding> result = new ArrayList();
            for (XmlFieldBinding binding : bindings) {
                if (binding == null) continue;
                result.add(binding);
            }
            result = this.proxy.store(result);
            return new ArrayList<XmlFieldBinding>(result);
        }
        return null;
    }

    @Override
    public TreeNode getRootThesaurus() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getRootThesaurus");
        }
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "TreeNode").eq("TreeNode.name", ROOT_THESAURUS_NAME).criteria();
        List rootThesaurus = this.proxy.findAllByCriteria(TreeNode.class, criteria).getAll();
        log.debug((Object)("Thesaurus find " + rootThesaurus));
        if (rootThesaurus.isEmpty()) {
            TreeNodeImpl thesaurusImpl = new TreeNodeImpl();
            thesaurusImpl.setName(ROOT_THESAURUS_NAME);
            this.updateEntity((BusinessEntity)thesaurusImpl);
            return thesaurusImpl;
        }
        return (TreeNode)rootThesaurus.get(0);
    }

    @Override
    public List<TreeNode> getAllThesaurus() throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllThesaurus");
        }
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (BusinessEntity entity : this.getAllEntities(TreeNode.class, "TreeNode")) {
            result.add((TreeNode)entity);
        }
        return result;
    }

    @Override
    public TreeNode getThesaurus(String thesaurusId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getThesaurus");
        }
        return (TreeNode)this.getEntity(thesaurusId, TreeNode.class);
    }

    @Override
    public XmlStream getXmlStream(String xmlStreamId) throws TechnicalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getXmlStream");
        }
        return (XmlStream)this.getEntity(xmlStreamId, XmlStream.class);
    }

    @Override
    public XmlFieldBinding getXmlFieldBinding(String xmlFieldBindingId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getXmlFieldBinding");
        }
        XmlFieldBinding result = null;
        if (xmlFieldBindingId != null) {
            result = (XmlFieldBinding)this.proxy.restore(XmlFieldBinding.class, xmlFieldBindingId);
        }
        return result;
    }

    @Override
    public List<XmlFieldBinding> getXmlFieldBindings(XmlStream xmlStream) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getXmlFieldBindings");
            log.debug((Object)xmlStream.getXmlFieldBinding());
        }
        if (xmlStream != null && xmlStream.getXmlFieldBinding() != null) {
            ArrayList bindings = new ArrayList();
            bindings.addAll(xmlStream.getXmlFieldBinding());
            return this.proxy.restore(XmlFieldBinding.class, bindings);
        }
        return null;
    }

    @Override
    public void bindFormsToClients() {
        ArrayList<SendingImpl> toSend = new ArrayList<SendingImpl>();
        try {
            ArrayList<Object> queryMakers = new ArrayList<Object>();
            List<Client> clients = this.getAllClients();
            for (Client client : clients) {
                Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Sending").eq("Sending.client", client.getWikittyId()).criteria();
                List sendings = this.proxy.findAllByCriteria(Sending.class, criteria).getAll();
                ArrayList<String> alreadySentFormIds = new ArrayList<String>();
                for (Sending sending : sendings) {
                    log.info((Object)sending.getForm());
                    alreadySentFormIds.addAll(sending.getForm());
                }
                queryMakers.add(client);
                List<User> users = this.getClientUsers(client.getWikittyId());
                queryMakers.addAll(users);
                for (QueryMaker queryMaker : queryMakers) {
                    if (queryMaker.getQueries() == null) continue;
                    for (String query : queryMaker.getQueries()) {
                        List<Form> forms = this.findForms(query);
                        ArrayList<String> formsToSendIds = new ArrayList<String>();
                        for (Form form : forms) {
                            if (alreadySentFormIds.contains(form.getWikittyId())) continue;
                            formsToSendIds.add(form.getWikittyId());
                        }
                        if (formsToSendIds.isEmpty()) continue;
                        SendingImpl sending = new SendingImpl();
                        sending.setClient(client.getWikittyId());
                        for (String formsToSendId : formsToSendIds) {
                            sending.addForm(formsToSendId);
                            alreadySentFormIds.add(formsToSendId);
                        }
                        sending.setSentDate(null);
                        sending.setReceptionDate(null);
                        sending.setParagraph(null);
                        sending.setReceptionProof(false);
                        sending.setStatus(defaultFormSendingStatus);
                        toSend.add(sending);
                    }
                }
                queryMakers.clear();
            }
            this.proxy.store(toSend);
        }
        catch (TechnicalException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<VradiSendingDTO> getFormsByClients(String dateType, Date beginDate, Date endDate, WikittyExtension extension) throws TechnicalException {
        ArrayList<VradiSendingDTO> result = new ArrayList<VradiSendingDTO>();
        List<Client> clients = this.getAllClients();
        for (Client client : clients) {
            Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Sending").eq("Sending.client", client.getWikittyId()).criteria();
            List sendings = this.proxy.findAllByCriteria(Sending.class, criteria).getAll();
            for (Sending sending : sendings) {
                int dot;
                List<Form> forms = this.getForms(new ArrayList<String>(sending.getForm()));
                String dateExtension = null;
                String dateTypeName = null;
                if (dateType != null && (dot = dateType.indexOf(46)) > 0) {
                    dateExtension = dateType.substring(0, dot);
                    dateTypeName = dateType.substring(dot + 1);
                }
                ArrayList<Form> formsToSend = new ArrayList<Form>();
                for (Form form : forms) {
                    if (extension != null && !form.getExtensions().contains(extension) || dateType != null && beginDate != null && beginDate.after((Date)form.getField(dateExtension, dateTypeName)) || dateType != null && endDate != null && endDate.before((Date)form.getField(dateExtension, dateTypeName))) continue;
                    formsToSend.add(form);
                }
                sending.setParagraph("test");
                VradiSendingDTO formsByClientDTO = new VradiSendingDTO();
                formsByClientDTO.fromWikitty(sending);
                formsByClientDTO.setFormDTOs(formsToSend);
                result.add(formsByClientDTO);
            }
        }
        return result;
    }

    @Override
    public Map<Form, List<Client>> getClientsByForms(String dateType, Date beginDate, Date endDate, WikittyExtension extension) {
        HashMap<Form, List<Client>> result = new HashMap<Form, List<Client>>();
        List<Form> forms = this.getAllForms();
        for (Form form : forms) {
            int dot;
            String dateExtension = null;
            String dateTypeName = null;
            if (dateType != null && (dot = dateType.indexOf(46)) > 0) {
                dateExtension = dateType.substring(0, dot);
                dateTypeName = dateType.substring(dot + 1);
            }
            if (extension != null && !form.getExtensions().contains(extension) || dateType != null && beginDate != null && beginDate.after((Date)form.getField(dateExtension, dateTypeName)) || dateType != null && endDate != null && endDate.before((Date)form.getField(dateExtension, dateTypeName))) continue;
            ArrayList<String> clientIds = new ArrayList<String>();
            Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "Sending").eq("Sending.form", form.getWikittyId()).criteria();
            List sendings = this.proxy.findAllByCriteria(Sending.class, criteria).getAll();
            for (Sending sending : sendings) {
                clientIds.add(sending.getClient());
            }
            result.put(form, this.proxy.restore(Client.class, clientIds));
        }
        return result;
    }

    @Override
    public String getFormsFromXmlStream(XmlStream xmlStream, String lastItemRecorded) {
        HashMap<String, Set> streamBinding = new HashMap<String, Set>();
        WikittyExtension formType = null;
        ArrayList<Form> forms = new ArrayList<Form>();
        log.debug((Object)xmlStream.getName());
        List bindings = this.proxy.restore(XmlFieldBinding.class, new ArrayList(xmlStream.getXmlFieldBinding()));
        for (XmlFieldBinding binding : bindings) {
            log.info((Object)binding.getFormField());
            String formTypeName = binding.getFormField().substring(0, binding.getFormField().indexOf(46));
            if (formType == null && !formTypeName.equals("Form")) {
                formType = this.getFormType(formTypeName);
            }
            streamBinding.put(binding.getFormField(), binding.getXmlField());
        }
        try {
            String result = null;
            SAXBuilder sxb = new SAXBuilder();
            URL rssUrl = new URL(xmlStream.getUrl());
            Document document = sxb.build(rssUrl);
            org.jdom.Element racine = document.getRootElement();
            List itemElt = null;
            if (racine.getChild(channel) != null) {
                itemElt = racine.getChild(channel).getChildren(item);
            } else if (racine.getChild(item) != null) {
                itemElt = racine.getChildren(item);
            } else if (racine.getChild(entry) != null) {
                itemElt = racine.getChildren(entry);
            }
            if (itemElt != null) {
                for (org.jdom.Element element : itemElt) {
                    StringBuffer sb = new StringBuffer();
                    List fields = element.getChildren();
                    for (org.jdom.Element field : fields) {
                        sb.append(field.getText());
                    }
                    MD5 lastItem = new MD5((Object)sb.toString());
                    if (result == null) {
                        result = MD5.asHex((byte[])lastItem.Final());
                    }
                    if (lastItemRecorded != null && lastItemRecorded.equals(MD5.asHex((byte[])lastItem.Final()))) break;
                    FormImpl form = new FormImpl();
                    form.addExtension(formType);
                    block8: for (String field : streamBinding.keySet()) {
                        int dot = field.indexOf(46);
                        String extName = field.substring(0, dot);
                        String fieldName = field.substring(dot + 1);
                        FieldType.TYPE fieldType = null;
                        if (extName.equals("Form")) {
                            fieldType = FormImpl.extensionForm.getFieldType(fieldName).getType();
                        } else if (formType != null) {
                            fieldType = formType.getFieldType(fieldName).getType();
                        }
                        if (fieldType == null || streamBinding.get(field) == null) continue;
                        switch (fieldType) {
                            case DATE: {
                                for (String xmlField : (Set)streamBinding.get(field)) {
                                    if (element.getChild(xmlField) == null) continue;
                                    form.setField(extName, fieldName, (Object)WikittyUtil.solrDateFormat.format(RSS_DATE_FORMAT.parse(element.getChild(xmlField).getText())));
                                }
                                continue block8;
                            }
                            default: {
                                for (String xmlField : (Set)streamBinding.get(field)) {
                                    if (element.getChild(xmlField) == null) continue;
                                    form.setField(extName, fieldName, (Object)((form.getField(extName, fieldName) != null ? form.getField(extName, fieldName) + "\n" : "") + element.getChild(xmlField).getText()));
                                }
                                continue block8;
                            }
                        }
                    }
                    if (form.getName() == null) {
                        form.setName(form.getWikittyId());
                    }
                    forms.add(this.updateForm((Form)form));
                }
            }
            return result;
        }
        catch (Exception eee) {
            eee.printStackTrace();
            return null;
        }
    }

    public List<String> getRSSFields(String url) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            SAXBuilder sxb = new SAXBuilder();
            URL rssUrl = new URL(url);
            Document document = sxb.build(rssUrl);
            org.jdom.Element racine = document.getRootElement();
            org.jdom.Element itemElt = racine.getChild(channel).getChild(item);
            for (org.jdom.Element elt : itemElt.getChildren()) {
                result.add(elt.getName());
            }
        }
        catch (Exception eee) {
            eee.printStackTrace();
        }
        return result;
    }

    @Override
    public void changeDataDir(String newDataDir, String oldDataDir) {
        this.proxy.changeDataDir(newDataDir, oldDataDir);
    }
}

