package com.jurismarches.vradi.services;

import java.util.List;

import org.sharengo.wikitty.TreeNodeImpl;

import com.caucho.hessian.client.HessianProxyFactory;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.services.dto.VradiFormPageDTO;

/**
 * HessianClient.
 *
 * @author $Author: chatellier $
 * @version $Revision: 729 $ $Date: 2010-04-20 11:57:04 +0200 (mar., 20 avril 2010) $
 * @since 17 févr. 2010 21:16:59
 */
public class HessianClient {
    public static void main(String[] args) throws VradiException, Exception {
        String url = "http://localhost:9000/storage";
        HessianProxyFactory factory = new HessianProxyFactory();
        VradiStorageService service = (VradiStorageService)
                factory.create(VradiStorageService.class, url);
        
        VradiUser user = service.logVradiUser("sch", "c340f4803161a481703d1c8bf74156ee");
        System.out.println("user: " + user);
        
        try {
            VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
            service.findForms2("", null, null, null, null, null, null, formPageDTO);
            System.out.println("formPageDTO: " + formPageDTO);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
        try {
            VradiFormPageDTO formPageDTO = new VradiFormPageDTO();
            formPageDTO = service.findForms("", formPageDTO);
            System.out.println("formPageDTO: " + formPageDTO);
        } catch (Exception e) {
            e.printStackTrace();
        }
        
//        try {
//            TreeNodeImpl rootThesaurus = service.getRootThesaurus();
//            loadAllChildrenNodes(service, rootThesaurus);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }

        System.exit(0);
    }
    
    public static void loadAllChildrenNodes(VradiStorageService service,
            TreeNodeImpl thesaurus) throws VradiException {
        int nbForms = service.getNbFormsForThesaurus(thesaurus
                .getWikittyId());
        System.out.println(thesaurus.getName() + " (" + nbForms + ")");

        List<TreeNodeImpl> childrenTreeNode = service
                .getChildrenThesaurus(thesaurus.getWikittyId());

        if (childrenTreeNode != null) {
            for (TreeNodeImpl child : childrenTreeNode) {
                loadAllChildrenNodes(service, child);
            }
        }
    }
}
