/*
 * Decompiled with CFR 0.152.
 */
package com.jgeppert.struts2.jquery.mobile.components;

import com.jgeppert.struts2.jquery.mobile.components.ThemeableBean;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.components.TextField;
import org.apache.struts2.views.annotations.StrutsTag;
import org.apache.struts2.views.annotations.StrutsTagAttribute;
import org.apache.struts2.views.annotations.StrutsTagSkipInheritance;

@StrutsTag(name="slider", tldTagClass="com.jgeppert.struts2.jquery.mobile.views.jsp.ui.SliderTag", description="Renders a slider field", allowDynamicAttributes=true)
public class Slider
extends TextField
implements ThemeableBean {
    public static final String TEMPLATE = "slider";
    public static final String COMPONENT_NAME = Slider.class.getName();
    private static final transient Random RANDOM = new Random();
    protected String dataTheme;
    protected String max;
    protected String min;

    public Slider(ValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    protected String getDefaultTemplate() {
        return TEMPLATE;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (this.dataTheme != null) {
            this.addParameter("dataTheme", this.findString(this.dataTheme));
        }
        if (this.max != null) {
            this.addParameter("max", this.findValue(this.max, Integer.class));
        }
        if (this.min != null) {
            this.addParameter("min", this.findValue(this.min, Integer.class));
        }
        if (this.id == null || this.id.length() == 0) {
            int nextInt = RANDOM.nextInt();
            nextInt = nextInt == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(nextInt);
            this.id = "slider_" + String.valueOf(nextInt);
            this.addParameter("id", this.id);
        }
    }

    @StrutsTagSkipInheritance
    public void setTheme(String theme) {
        super.setTheme(theme);
    }

    public String getTheme() {
        return "mobile";
    }

    @StrutsTagAttribute(description="Initialize a slider with the max option specified. Default: 100", type="Integer")
    public void setMax(String max) {
        this.max = max;
    }

    @StrutsTagAttribute(description="The minimum value of the slider. Default: 0", type="Integer")
    public void setMin(String min) {
        this.min = min;
    }

    @StrutsTagAttribute(description="Set the Slider theme. e.g. a,b,c,d or e")
    public void setDataTheme(String dataTheme) {
        this.dataTheme = dataTheme;
    }
}

