/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;

public class FileSystemInputFile
implements InputFile {
    private final File file;

    public FileSystemInputFile(File file) {
        this.file = file;
    }

    public long getLength() throws IOException {
        return this.file.length();
    }

    public SeekableInputStream newStream() throws IOException {
        return new SeekableFileInputStream(this.file);
    }

    private static class SeekableFileInputStream
    extends SeekableInputStream {
        private static final int COPY_SIZE = 16384;
        private final RandomAccessFile file;
        private final byte[] copyBuffer = new byte[16384];
        private long markedPos = 0L;

        SeekableFileInputStream(File file) throws IOException {
            this.file = new RandomAccessFile(file, "r");
        }

        public long getLength() throws IOException {
            return this.file.length();
        }

        public int read() throws IOException {
            return this.file.read();
        }

        public int read(byte[] b) throws IOException {
            return this.file.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.file.read(b, off, len);
        }

        public long skip(long skipCount) throws IOException {
            long fileLenght;
            if (skipCount <= 0L) {
                return 0L;
            }
            long currentOffset = this.getPos();
            if (currentOffset >= (fileLenght = this.getLength())) {
                return 0L;
            }
            long newPos = Math.min(currentOffset + skipCount, fileLenght);
            this.seek(newPos);
            long curPos = this.getPos();
            assert (curPos == newPos);
            return curPos - currentOffset;
        }

        public int available() throws IOException {
            long remaining = this.getLength() - this.getPos();
            if (remaining > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)remaining;
        }

        public void close() throws IOException {
            this.file.close();
        }

        public synchronized void mark(int readlimit) {
            try {
                this.markedPos = this.getPos();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized void reset() throws IOException {
            this.file.seek(this.markedPos);
        }

        public boolean markSupported() {
            return true;
        }

        public long getPos() throws IOException {
            return this.file.getFilePointer();
        }

        public void seek(long l) throws IOException {
            this.file.seek(l);
        }

        public void readFully(byte[] bytes) throws IOException {
            this.file.readFully(bytes);
        }

        public void readFully(byte[] bytes, int start, int len) throws IOException {
            this.file.readFully(bytes, start, len);
        }

        public int read(ByteBuffer byteBuffer) throws IOException {
            int readedBytes;
            int bytesToRead = this.getBytesToRead(byteBuffer);
            int totalBytesReaded = 0;
            while ((readedBytes = this.file.read(this.copyBuffer, 0, bytesToRead)) == 16384) {
                totalBytesReaded += readedBytes;
                byteBuffer.put(this.copyBuffer);
                bytesToRead = this.getBytesToRead(byteBuffer);
            }
            if (readedBytes < 0) {
                return totalBytesReaded == 0 ? -1 : totalBytesReaded;
            }
            byteBuffer.put(this.copyBuffer, 0, readedBytes);
            return totalBytesReaded + readedBytes;
        }

        public void readFully(ByteBuffer byteBuffer) throws IOException {
            int bytesToRead = this.getBytesToRead(byteBuffer);
            int readedBytes = 0;
            while (bytesToRead > 0 && (readedBytes = this.file.read(this.copyBuffer, 0, bytesToRead)) >= 0) {
                byteBuffer.put(this.copyBuffer, 0, readedBytes);
                bytesToRead = this.getBytesToRead(byteBuffer);
            }
            if (readedBytes < 0 && byteBuffer.remaining() > 0) {
                throw new IOException("Missing " + byteBuffer.remaining() + " bytes left to read from File");
            }
        }

        private int getBytesToRead(ByteBuffer byteBufr) {
            return Math.min(byteBufr.remaining(), 16384);
        }
    }
}

