/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.parquet.io.PositionOutputStream;

class CountedPositionOutputStream
extends PositionOutputStream {
    private final BufferedOutputStream bos;
    private long pos = 0L;

    CountedPositionOutputStream(OutputStream os) {
        this.bos = new BufferedOutputStream(os);
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public void flush() throws IOException {
        this.bos.flush();
    }

    public void close() throws IOException {
        this.bos.close();
    }

    public void write(int b) throws IOException {
        this.bos.write(b);
        ++this.pos;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.bos.write(b, off, len);
        this.pos += (long)len;
    }

    public void write(byte[] b) throws IOException {
        this.bos.write(b);
        this.pos += (long)b.length;
    }
}

