/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl;

import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedCollection;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;

public class ParameterizedMap {
    private final Type mapType;
    private final AnnotatedType keyAnnotatedMapElementType;
    private final AnnotatedType valueAnnotatedMapElementType;

    public ParameterizedMap(Type mapType, AnnotatedParameterizedType type) {
        this.mapType = mapType;
        AnnotatedType[] annotatedActualTypeArguments = type.getAnnotatedActualTypeArguments();
        this.keyAnnotatedMapElementType = annotatedActualTypeArguments[0];
        this.valueAnnotatedMapElementType = annotatedActualTypeArguments[1];
    }

    public Class<?> getMapType() {
        return (Class)this.mapType;
    }

    public Class<?> getValueActualType() {
        return Parameterized.getClassFromType(this.valueAnnotatedMapElementType.getType(), "in Map value");
    }

    public JavaType getValueActualJavaType() {
        return new JavaType(this.getValueActualType(), this.getValueAnnotations());
    }

    private Annotation[] getValueAnnotations() {
        return this.valueAnnotatedMapElementType.getDeclaredAnnotations();
    }

    public Class<?> getKeyActualType() {
        return Parameterized.getClassFromType(this.keyAnnotatedMapElementType.getType(), "in Map key");
    }

    public JavaType getKeyActualJavaType() {
        return new JavaType(this.getKeyActualType(), this.getKeyAnnotations());
    }

    private Annotation[] getKeyAnnotations() {
        return this.keyAnnotatedMapElementType.getDeclaredAnnotations();
    }

    public ParameterizedMap getValueTypeAsMap() {
        return Parameterized.getParameterizedMap(this.valueAnnotatedMapElementType);
    }

    public ParameterizedCollection getValueTypeAsCollection() {
        return Parameterized.getParameterizedCollection(this.valueAnnotatedMapElementType);
    }

    public boolean valueIsCollection() {
        return Parameterized.isCollection(this.valueAnnotatedMapElementType.getType());
    }

    public boolean valueIsMap() {
        return Parameterized.isMap(this.valueAnnotatedMapElementType.getType());
    }

    public boolean keyIsCollection() {
        return Parameterized.isCollection(this.keyAnnotatedMapElementType.getType());
    }

    public boolean keyIsMap() {
        return Parameterized.isMap(this.keyAnnotatedMapElementType.getType());
    }
}

