/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet.impl;

import com.jerolba.carpet.impl.JavaType;
import com.jerolba.carpet.impl.Parameterized;
import com.jerolba.carpet.impl.ParameterizedMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;

public class ParameterizedCollection {
    private final Type collectionType;
    private final Type collectionElementType;
    private final AnnotatedType annotatedCollectionElementType;

    public ParameterizedCollection(Type collectionType, AnnotatedParameterizedType type) {
        this.collectionType = collectionType;
        this.annotatedCollectionElementType = type.getAnnotatedActualTypeArguments()[0];
        this.collectionElementType = this.annotatedCollectionElementType.getType();
    }

    public Class<?> getActualType() {
        return Parameterized.getClassFromType(this.collectionElementType, "in Collection");
    }

    public JavaType getActualJavaType() {
        return new JavaType(this.getActualType(), this.getAnnotations());
    }

    public Class<?> getCollectionType() {
        return (Class)this.collectionType;
    }

    public ParameterizedCollection getParametizedAsCollection() {
        return Parameterized.getParameterizedCollection(this.annotatedCollectionElementType);
    }

    public ParameterizedMap getParametizedAsMap() {
        return Parameterized.getParameterizedMap(this.annotatedCollectionElementType);
    }

    public boolean isCollection() {
        return Parameterized.isCollection(this.collectionElementType);
    }

    public boolean isMap() {
        return Parameterized.isMap(this.collectionElementType);
    }

    private Annotation[] getAnnotations() {
        return this.annotatedCollectionElementType.getDeclaredAnnotations();
    }
}

