/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet;

import com.jerolba.carpet.RecordTypeConversionException;
import com.jerolba.carpet.impl.read.SchemaValidation;
import com.jerolba.carpet.io.FileSystemInputFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.conf.ParquetConfiguration;
import org.apache.parquet.conf.PlainParquetConfiguration;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class CarpetRecordGenerator {
    public static List<String> generateCode(String filePath) throws IOException {
        return CarpetRecordGenerator.generateCode(new File(filePath));
    }

    public static List<String> generateCode(File file) throws IOException {
        FileSystemInputFile inputFile = new FileSystemInputFile(file);
        return CarpetRecordGenerator.generateCode(inputFile);
    }

    public static List<String> generateCode(InputFile inputFile) throws IOException {
        return new RecordCodeBuilder().calculate(inputFile);
    }

    private static String extractClassName(String str) {
        String name = str;
        int lastIndexOf = str.lastIndexOf(".");
        if (lastIndexOf > 0) {
            name = str.substring(lastIndexOf + 1);
        }
        return CarpetRecordGenerator.capitalize(name);
    }

    private static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static class RecordCodeBuilder {
        private RecordCodeBuilder() {
        }

        private List<String> calculate(InputFile inputFile) throws IOException {
            ParquetReadOptions readOptions = ParquetReadOptions.builder((ParquetConfiguration)new PlainParquetConfiguration()).build();
            ParquetFileReader fileReader = ParquetFileReader.open((InputFile)inputFile, (ParquetReadOptions)readOptions);
            MessageType schema = fileReader.getFileMetaData().getSchema();
            SchemaInspector inspector = new SchemaInspector();
            RecordMetadata generated = inspector.inspectGroup((GroupType)schema, schema.getName()).recordClass();
            Set<RecordMetadata> allClasses = new TreeTraversal().locateClassesInTree(generated);
            CodeGenerator codeGenerator = new CodeGenerator();
            return allClasses.stream().map(codeGenerator::recordToString).toList();
        }

        private static class SchemaInspector {
            private final Map<Set<Type>, RecordType> existingRecords = new HashMap<Set<Type>, RecordType>();

            private SchemaInspector() {
            }

            private RecordType inspectGroup(GroupType groupType, String inheritedName) {
                HashSet fieldsSet = new HashSet(groupType.getFields());
                if (this.existingRecords.containsKey(fieldsSet)) {
                    return this.existingRecords.get(fieldsSet);
                }
                RecordMetadata current = new RecordMetadata(groupType, inheritedName);
                for (Type schemaField : groupType.getFields()) {
                    FieldType fieldType = this.buildField(schemaField, schemaField.getName());
                    if (schemaField.isRepetition(Type.Repetition.REPEATED)) {
                        fieldType = new ListType(fieldType);
                    }
                    current.fields().add(new RecordField(fieldType, schemaField));
                }
                RecordType recordType = new RecordType(current);
                this.existingRecords.put(fieldsSet, recordType);
                return recordType;
            }

            private FieldType buildField(Type field, String fieldName) {
                if (field.isPrimitive()) {
                    return PrimitiveFieldFactory.buildRecordField(field);
                }
                GroupType asGroupType = field.asGroupType();
                LogicalTypeAnnotation logicalType = asGroupType.getLogicalTypeAnnotation();
                if (LogicalTypeAnnotation.listType().equals((Object)logicalType)) {
                    return this.inspectListField(asGroupType, fieldName);
                }
                if (LogicalTypeAnnotation.mapType().equals((Object)logicalType)) {
                    return this.inspectMapField(asGroupType, fieldName);
                }
                return this.inspectGroup(field.asGroupType(), fieldName);
            }

            private FieldType inspectListField(GroupType listField, String listFieldName) {
                Type listChild = (Type)listField.getFields().get(0);
                Type listElement = SchemaValidation.isThreeLevel(listChild) ? (Type)listChild.asGroupType().getFields().get(0) : listChild;
                return new ListType(this.buildField(listElement, listFieldName));
            }

            private FieldType inspectMapField(GroupType mapField, String mapFieldName) {
                List fields = mapField.getFields();
                if (fields.size() > 1) {
                    throw new RecordTypeConversionException(mapField.getName() + " MAP can not have more than one field");
                }
                GroupType mapChild = ((Type)fields.get(0)).asGroupType();
                List mapFields = mapChild.getFields();
                if (mapFields.size() != 2) {
                    throw new RecordTypeConversionException(mapField.getName() + " MAP child element must have two fields");
                }
                FieldType keyType = this.buildField((Type)mapFields.get(0), mapFieldName + "Key");
                FieldType valueType = this.buildField((Type)mapFields.get(1), mapFieldName);
                return new MapType(keyType, valueType);
            }
        }

        private static class TreeTraversal {
            private TreeTraversal() {
            }

            private Set<RecordMetadata> locateClassesInTree(RecordMetadata generated) {
                LinkedHashSet<RecordMetadata> lst = new LinkedHashSet<RecordMetadata>();
                List<RecordField> fields = generated.fields;
                for (RecordField field : fields) {
                    lst.addAll(this.locateRecords(field.fieldType));
                }
                lst.add(generated);
                return lst;
            }

            private Set<RecordMetadata> locateRecords(FieldType type) {
                if (type instanceof RecordType) {
                    RecordType r = (RecordType)type;
                    return this.locateClassesInTree(r.recordClass);
                }
                if (type instanceof ListType) {
                    ListType rec = (ListType)type;
                    return this.locateRecords(rec.listType);
                }
                if (type instanceof MapType) {
                    MapType map = (MapType)type;
                    LinkedHashSet<RecordMetadata> mapClasses = new LinkedHashSet<RecordMetadata>();
                    mapClasses.addAll(this.locateRecords(map.keyType));
                    mapClasses.addAll(this.locateRecords(map.valueType));
                    return mapClasses;
                }
                return Set.of();
            }
        }

        private static class CodeGenerator {
            private CodeGenerator() {
            }

            private String recordToString(RecordMetadata generated) {
                List<RecordField> fields = generated.fields;
                String value = "record " + generated.recorddName + "(";
                boolean first = true;
                for (RecordField field : fields) {
                    FieldType type = field.fieldType;
                    if (!first) {
                        value = value + ", ";
                    }
                    value = value + type.getJavaType() + " " + field.name;
                    first = false;
                }
                value = value + ") {}";
                return value;
            }
        }
    }

    private static class PrimitiveFieldFactory {
        private PrimitiveFieldFactory() {
        }

        static FieldType buildRecordField(Type parquetField) {
            PrimitiveType.PrimitiveTypeName typeName = parquetField.asPrimitiveType().getPrimitiveTypeName();
            BasicTypes basicType = PrimitiveFieldFactory.buildFromLogicalType(parquetField);
            if (basicType == null) {
                basicType = switch (typeName) {
                    case PrimitiveType.PrimitiveTypeName.INT32 -> BasicTypes.INT_TYPE;
                    case PrimitiveType.PrimitiveTypeName.INT64 -> BasicTypes.LONG_TYPE;
                    case PrimitiveType.PrimitiveTypeName.FLOAT -> BasicTypes.FLOAT_TYPE;
                    case PrimitiveType.PrimitiveTypeName.DOUBLE -> BasicTypes.DOUBLE_TYPE;
                    case PrimitiveType.PrimitiveTypeName.BOOLEAN -> BasicTypes.BOOLEAN_TYPE;
                    case PrimitiveType.PrimitiveTypeName.BINARY -> BasicTypes.BINARY;
                    default -> throw new RecordTypeConversionException(String.valueOf(typeName) + " deserialization not supported");
                };
            }
            return new BasicType(basicType, parquetField.isRepetition(Type.Repetition.REQUIRED));
        }

        static BasicTypes buildFromLogicalType(Type parquetField) {
            LogicalTypeAnnotation logicalType = parquetField.getLogicalTypeAnnotation();
            if (logicalType == null) {
                return null;
            }
            if (logicalType.equals(LogicalTypeAnnotation.stringType()) || logicalType.equals(LogicalTypeAnnotation.enumType())) {
                return BasicTypes.STRING_TYPE;
            }
            if (logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
                LogicalTypeAnnotation.IntLogicalTypeAnnotation intType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType;
                return switch (intType.getBitWidth()) {
                    case 8 -> BasicTypes.BYTE_TYPE;
                    case 16 -> BasicTypes.SHORT_TYPE;
                    default -> BasicTypes.INT_TYPE;
                };
            }
            if (logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
                return BasicTypes.DECIMAL_TYPE;
            }
            PrimitiveType.PrimitiveTypeName primitiveTypeName = parquetField.asPrimitiveType().getPrimitiveTypeName();
            if (logicalType.equals(LogicalTypeAnnotation.uuidType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
                return BasicTypes.UUID_TYPE;
            }
            if (logicalType.equals(LogicalTypeAnnotation.dateType()) && primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32) {
                return BasicTypes.LOCAL_DATE_TYPE;
            }
            if (logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation && (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 || primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64)) {
                return BasicTypes.LOCAL_TIME_TYPE;
            }
            if (logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timeStamp = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType;
                if (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64) {
                    if (timeStamp.isAdjustedToUTC()) {
                        return BasicTypes.INSTANT_TYPE;
                    }
                    return BasicTypes.LOCAL_DATE_TIME_TYPE;
                }
            }
            return null;
        }
    }

    private static enum BasicTypes {
        BYTE_TYPE("byte", "Byte"),
        SHORT_TYPE("short", "Short"),
        INT_TYPE("int", "Integer"),
        LONG_TYPE("long", "Long"),
        FLOAT_TYPE("float", "Float"),
        DOUBLE_TYPE("double", "Double"),
        BOOLEAN_TYPE("boolean", "Boolean"),
        STRING_TYPE("String"),
        ENUM_TYPE("String"),
        UUID_TYPE("UUID"),
        LOCAL_DATE_TYPE("LocalDate"),
        LOCAL_TIME_TYPE("LocalTime"),
        LOCAL_DATE_TIME_TYPE("LocalDateTime"),
        INSTANT_TYPE("Instant"),
        DECIMAL_TYPE("BigDecimal"),
        BINARY("Binary");

        private final String primitive;
        private final String object;

        private BasicTypes(String primitive, String object) {
            this.primitive = primitive;
            this.object = object;
        }

        private BasicTypes(String object) {
            this(object, object);
        }
    }

    private record RecordField(FieldType fieldType, String name) {
        public RecordField(FieldType type, Type parquetField) {
            this(type, parquetField.getName());
        }
    }

    private record RecordType(RecordMetadata recordClass) implements FieldType
    {
        @Override
        public String getJavaType() {
            return this.recordClass.recorddName;
        }
    }

    private record MapType(FieldType keyType, FieldType valueType) implements FieldType
    {
        @Override
        public String getJavaType() {
            return "Map<" + this.keyType.getJavaType() + ", " + this.valueType.getJavaType() + ">";
        }
    }

    private record ListType(FieldType listType) implements FieldType
    {
        @Override
        public String getJavaType() {
            return "List<" + this.listType.getJavaType() + ">";
        }
    }

    private record BasicType(BasicTypes type, boolean notNull) implements FieldType
    {
        @Override
        public String getJavaType() {
            return this.notNull ? this.type.primitive : this.type.object;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface FieldType {
        public String getJavaType();
    }

    private record RecordMetadata(GroupType groupType, String recorddName, List<RecordField> fields) {
        public RecordMetadata(GroupType groupType, String inheritedName) {
            this(groupType, CarpetRecordGenerator.extractClassName(inheritedName), new ArrayList<RecordField>());
        }
    }
}

