/*
 * Decompiled with CFR 0.152.
 */
package com.jerolba.carpet;

import com.jerolba.carpet.CarpetReaderConfigurationBuilder;
import com.jerolba.carpet.CloseableIterator;
import com.jerolba.carpet.FieldMatchingStrategy;
import com.jerolba.carpet.impl.read.ParquetRecordIterator;
import com.jerolba.carpet.io.FileSystemInputFile;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.parquet.io.InputFile;

public class CarpetReader<T>
implements Iterable<T> {
    private final Builder<T> builder;

    public CarpetReader(InputFile inputFile, Class<T> recordClass) {
        this(new Builder<T>(inputFile, recordClass));
    }

    public CarpetReader(File file, Class<T> recordClass) {
        this(new FileSystemInputFile(file), recordClass);
    }

    private CarpetReader(Builder<T> builder) {
        this.builder = builder;
    }

    public CarpetReader<T> withFailOnMissingColumn(boolean value) {
        this.builder.failOnMissingColumn(value);
        return this;
    }

    public CarpetReader<T> withFailOnNullForPrimitives(boolean value) {
        this.builder.failOnNullForPrimitives(value);
        return this;
    }

    public CarpetReader<T> withFailNarrowingPrimitiveConversion(boolean value) {
        this.builder.failNarrowingPrimitiveConversion(value);
        return this;
    }

    public CarpetReader<T> withFieldMatchingStrategy(FieldMatchingStrategy value) {
        this.builder.fieldMatchingStrategy(value);
        return this;
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.buildIterator();
    }

    public Stream<T> stream() {
        ParquetRecordIterator<T> iterator = this.buildIterator();
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 1296);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(iterator::uncheckedCloseReader);
    }

    public List<T> toList() throws IOException {
        ArrayList<T> result = new ArrayList<T>();
        try (ParquetRecordIterator<T> iterator = this.buildIterator();){
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
            ArrayList<T> arrayList = result;
            return arrayList;
        }
    }

    private ParquetRecordIterator<T> buildIterator() {
        try {
            return new ParquetRecordIterator(this.builder.buildParquetReader());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static class Builder<T>
    extends CarpetReaderConfigurationBuilder<T, Builder<T>> {
        public Builder(InputFile file, Class<T> readClass) {
            super(file, readClass);
        }

        public Builder(File file, Class<T> recordClass) {
            super(file, recordClass);
        }

        @Override
        protected Builder<T> self() {
            return this;
        }

        public CarpetReader<T> build() {
            return new CarpetReader(this);
        }
    }
}

