/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.local.shared.access;

import com.amazonaws.services.dynamodbv2.exceptions.AWSExceptionFactory;
import com.amazonaws.services.dynamodbv2.exceptions.AmazonServiceExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.access.DDBType;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessException;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBAccessExceptionType;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientException;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionMessage;
import com.amazonaws.services.dynamodbv2.local.shared.exceptions.LocalDBClientExceptionType;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LocalDBUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final int HASH_KEY_LOC = 0;
    public static final int RANGE_KEY_LOC = 1;
    public static final int MIN_EXPONENT = -130;
    public static final int MAX_EXPONENT = 126;
    public static final int MAX_PRECISION = 38;
    public static final int MAX_RETURNED_BATCH_GET = 100;
    public static final int MAX_ITEMS_BATCH_WRITE = 25;
    public static final int MAX_LIST_TABLES_LIMIT = 100;
    public static final long MAX_PROJECTED_ATTRIBUTES = 20L;
    public static final long MAX_ITEM_SIZE_BYTES = 65536L;
    public static final long MAX_HASH_KEY_VALUE_SIZE_BYTES = 2048L;
    public static final long MAX_RANGE_KEY_VALUE_SIZE_BYTES = 1024L;
    public static final long MB_RETURN_MAX = 0x100000L;
    public static final long MAX_THROUGHPUT_TABLE = 40000L;
    public static final long MAX_THROUGHPUT_ACCOUNT = 80000L;
    public static final int MAX_LSI_PER_TABLE = 5;
    public static final int MAX_GSI_PER_TABLE = 5;
    public static final int MAX_TOTAL_SEGMENTS = 4096;
    public static final int NUMBER_EXPONENT_BOUND_START = -128;
    public static final int NUMBER_EXPONENT_BOUND_END = 126;
    public static final int MAX_NUMBER_OF_DIGITS_TO_ENCODE = 38;
    public static final int MAX_NUMBER_OF_BYTES_WITHOUT_EXPONENT = 20;
    public static final int SHA1_KEY_SIZE = 20;
    public static final byte[] MAX_SHA1_BYTES = new byte[20];
    public static final BigInteger MAX_HASH_KEY;
    private static final byte[] SALT;
    private static final ThreadLocal<MessageDigest> m_digest;

    static {
        Arrays.fill(MAX_SHA1_BYTES, (byte)-1);
        MAX_HASH_KEY = new BigInteger(1, MAX_SHA1_BYTES);
        SALT = new byte[]{76, 111, 99, 97, 108, 68, 100, 98};
        m_digest = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                try {
                    return MessageDigest.getInstance("SHA1");
                }
                catch (NoSuchAlgorithmException ex) {
                    return null;
                }
            }
        };
    }

    public static AttributeDefinition findAttributeDefinition(KeySchemaElement attributeToFind, List<AttributeDefinition> attributes) {
        String attrName = attributeToFind.getAttributeName();
        for (AttributeDefinition curAttr : attributes) {
            String curName = curAttr.getAttributeName();
            if (!curName.equals(attrName)) continue;
            return curAttr;
        }
        return null;
    }

    public static DDBType getDataTypeOfAttributeDefinition(AttributeDefinition attrDef) {
        String datatype = attrDef.getAttributeType();
        if (datatype == null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NO_DATATYPE.getMessage());
        }
        if (datatype.equals("S")) {
            return DDBType.S;
        }
        if (datatype.equals("B")) {
            return DDBType.B;
        }
        if (datatype.equals("N")) {
            return DDBType.N;
        }
        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_DATATYPE.getMessage());
    }

    public static DDBType getDataTypeOfScalarAttributeValue(AttributeValue attrVal) {
        boolean defined = false;
        DDBType type = null;
        if (attrVal.getB() != null) {
            defined = true;
            type = DDBType.B;
        }
        if (attrVal.getS() != null) {
            if (attrVal.getS().isEmpty()) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.EMPTY_STRING_ATTRIBUTE_VALUE.getMessage());
            }
            if (defined) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DOUBLE_DATATYPE.getMessage());
            }
            defined = true;
            type = DDBType.S;
        }
        if (attrVal.getN() != null) {
            if (defined) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DOUBLE_DATATYPE.getMessage());
            }
            defined = true;
            type = DDBType.N;
            LocalDBUtils.validateNumericValue(attrVal.getN()).toPlainString();
        }
        if (!defined) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_DATATYPE.getMessage());
        }
        if (attrVal.getNS() != null || attrVal.getSS() != null || attrVal.getBS() != null) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DOUBLE_DATATYPE.getMessage());
        }
        return type;
    }

    static boolean isScalar(AttributeValue attrVal) {
        return attrVal.getB() != null || attrVal.getN() != null || attrVal.getS() != null;
    }

    public static DDBType getDataTypeOfAttributeValue(AttributeValue attrVal) {
        boolean defined = false;
        DDBType type = null;
        if (LocalDBUtils.isScalar(attrVal)) {
            type = LocalDBUtils.getDataTypeOfScalarAttributeValue(attrVal);
            defined = true;
        }
        if (attrVal.getBS() != null) {
            if (defined) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DOUBLE_DATATYPE.getMessage());
            }
            LocalDBUtils.validateItemSet(attrVal.getBS());
            type = DDBType.BS;
            defined = true;
        }
        if (attrVal.getSS() != null) {
            if (defined) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DOUBLE_DATATYPE.getMessage());
            }
            LocalDBUtils.validateItemSet(attrVal.getSS());
            if (attrVal.getSS().contains("")) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.EMPTY_STRING_ATTRIBUTE_VALUE.getMessage());
            }
            type = DDBType.SS;
            defined = true;
        }
        if (attrVal.getNS() != null) {
            if (defined) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DOUBLE_DATATYPE.getMessage());
            }
            LocalDBUtils.validateNumberSet(attrVal.getNS());
            type = DDBType.NS;
            defined = true;
        }
        if (!defined) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_DATATYPE.getMessage());
        }
        return type;
    }

    public static BigDecimal validateNumericValue(String numVal) {
        try {
            BigDecimal value = new BigDecimal(numVal);
            int significantDigits = value.stripTrailingZeros().precision();
            if (significantDigits > 38) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NUMBER_TOO_PRECISE.getMessage());
            }
            int exponent = value.precision() - value.scale() - 1;
            if (value.compareTo(BigDecimal.ZERO) != 0 && (exponent < -130 || exponent >= 126)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NUMBER_OUT_OF_RANGE.getMessage());
            }
            return value.stripTrailingZeros();
        }
        catch (NumberFormatException nfe) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.NON_NUMERIC_VALUE.getMessage());
        }
    }

    public static List<String> validateNumberSet(List<String> numberSet) {
        if (numberSet.isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SET_EMPTY.getMessage());
        }
        ArrayList<String> numberListTrimmed = new ArrayList<String>();
        HashSet<BigDecimal> allNumbers = new HashSet<BigDecimal>();
        for (String curNum : numberSet) {
            BigDecimal curBigDecimal = LocalDBUtils.validateNumericValue(curNum);
            for (BigDecimal existingBigDecimal : allNumbers) {
                if (curBigDecimal.compareTo(existingBigDecimal) != 0) continue;
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SET_DUPLICATES.getMessage());
            }
            allNumbers.add(curBigDecimal);
            numberListTrimmed.add(curBigDecimal.toPlainString());
        }
        return numberListTrimmed;
    }

    public static <T> void validateItemSet(List<T> itemSet) {
        if (itemSet == null) {
            return;
        }
        if (itemSet.isEmpty()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SET_EMPTY.getMessage());
        }
        HashSet<T> allItems = new HashSet<T>();
        for (T curItem : itemSet) {
            if (allItems.contains(curItem)) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INVALID_SET_DUPLICATES.getMessage());
            }
            allItems.add(curItem);
        }
    }

    public static Map<String, AttributeValue> filterAttributes(Map<String, AttributeValue> item, List<String> attributesToGet) {
        if (item == null) {
            return item;
        }
        if (attributesToGet == null) {
            return item;
        }
        HashMap<String, AttributeValue> filteredItem = new HashMap<String, AttributeValue>();
        for (String attrName : attributesToGet) {
            if (!item.containsKey(attrName)) continue;
            filteredItem.put(attrName, item.get(attrName));
        }
        return filteredItem;
    }

    public static List<Map<String, AttributeValue>> filterAttributesList(List<Map<String, AttributeValue>> itemsList, List<String> attributesToGet) {
        if (attributesToGet == null) {
            return itemsList;
        }
        ArrayList<Map<String, AttributeValue>> filteredItems = new ArrayList<Map<String, AttributeValue>>();
        for (Map<String, AttributeValue> item : itemsList) {
            filteredItems.add(LocalDBUtils.filterAttributes(item, attributesToGet));
        }
        return filteredItems;
    }

    public static long getItemSizeBytes(Map<String, AttributeValue> item) {
        long itemSizeBytes = 0L;
        for (String attrName : item.keySet()) {
            itemSizeBytes += (long)attrName.getBytes(UTF8).length;
            itemSizeBytes += LocalDBUtils.getAttributeValueSizeBytes(item.get(attrName));
        }
        return itemSizeBytes;
    }

    public static long getAttributeValueSizeBytes(AttributeValue attrVal) {
        long setSizeBytes = 0L;
        DDBType type = LocalDBUtils.getDataTypeOfAttributeValue(attrVal);
        switch (type) {
            case S: {
                return attrVal.getS().getBytes(UTF8).length;
            }
            case N: {
                return attrVal.getN().getBytes(UTF8).length;
            }
            case B: {
                return attrVal.getB().array().length;
            }
            case SS: {
                for (String s : attrVal.getSS()) {
                    setSizeBytes += (long)s.getBytes(UTF8).length;
                }
                return setSizeBytes;
            }
            case NS: {
                for (String n : attrVal.getNS()) {
                    setSizeBytes += (long)n.getBytes(UTF8).length;
                }
                return setSizeBytes;
            }
            case BS: {
                for (ByteBuffer b : attrVal.getBS()) {
                    setSizeBytes += (long)b.array().length;
                }
                return setSizeBytes;
            }
        }
        LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
        return 0L;
    }

    public static void ldAccessAssertTrue(boolean condition, LocalDBAccessExceptionType type, String failureMessage, Object ... args) {
        if (!condition) {
            LocalDBUtils.ldAccessFail(type, failureMessage, args);
        }
    }

    public static void ldAccessFail(LocalDBAccessExceptionType type, String message, Object ... args) {
        throw new LocalDBAccessException(type, String.format(message, args));
    }

    public static void ldAccessFail(LocalDBAccessExceptionType type) {
        throw new LocalDBAccessException(type, type.getMessage());
    }

    public static void ldClientAssertTrue(boolean condition, LocalDBClientExceptionType type, String failureMessage, Object ... args) {
        if (!condition) {
            LocalDBUtils.ldClientFail(type, failureMessage, args);
        }
    }

    public static void ldClientFail(LocalDBClientExceptionType type, String message, Object ... args) {
        throw new LocalDBClientException(type, String.format(message, args));
    }

    public static void ldClientFail(LocalDBClientExceptionType type) {
        throw new LocalDBClientException(type, type.getMessage());
    }

    public static DDBType validateConsistentTypes(AttributeDefinition attrDef, AttributeValue expectedVal) {
        DDBType expectedType;
        DDBType requestType = LocalDBUtils.getDataTypeOfAttributeValue(expectedVal);
        if (requestType != (expectedType = LocalDBUtils.getDataTypeOfAttributeDefinition(attrDef))) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage());
        }
        return requestType;
    }

    public static DDBType validateConsistentTypes(AttributeValue attrVal, AttributeValue expectedVal) {
        DDBType expectedType;
        DDBType requestType = LocalDBUtils.getDataTypeOfAttributeValue(expectedVal);
        if (requestType != (expectedType = LocalDBUtils.getDataTypeOfAttributeValue(attrVal))) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.INCONSISTENT_TYPES.getMessage());
        }
        return requestType;
    }

    public static byte[] getHashValue(AttributeValue attrValue) {
        if (attrValue.getB() != null) {
            return LocalDBUtils.generateSHA1(attrValue.getB().array());
        }
        if (attrValue.getN() != null) {
            return LocalDBUtils.generateSHA1(LocalDBUtils.encodeBigDecimal(new BigDecimal(attrValue.getN())));
        }
        if (attrValue.getS() != null) {
            return LocalDBUtils.generateSHA1(attrValue.getS().getBytes(UTF8));
        }
        return null;
    }

    public static byte[] getHashValue(AttributeValue ... attributeValues) {
        ArrayList<byte[]> attributehashValues = new ArrayList<byte[]>();
        AttributeValue[] attributeValueArray = attributeValues;
        int n = attributeValues.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeValue attrValue = attributeValueArray[n2];
            attributehashValues.add(LocalDBUtils.getHashValue(attrValue));
            ++n2;
        }
        return LocalDBUtils.generateSHA1(attributehashValues);
    }

    static byte[] bigIntegerToSHA1Bytes(BigInteger number) {
        byte[] numberBytes = number.toByteArray();
        if (numberBytes.length == 20) {
            return numberBytes;
        }
        byte[] bytes = new byte[20];
        int i = bytes.length - 1;
        int j = i + numberBytes.length - bytes.length;
        while (i >= 0 && j >= 0) {
            bytes[i] = numberBytes[j];
            --i;
            --j;
        }
        while (i >= 0) {
            bytes[i] = 0;
            --i;
        }
        return bytes;
    }

    private static byte[] generateSHA1(byte[] ba) {
        MessageDigest md = m_digest.get();
        md.update(SALT);
        return md.digest(ba);
    }

    public static byte[] generateSHA1(List<byte[]> keys) {
        MessageDigest md = m_digest.get();
        md.update(SALT);
        for (byte[] ba : keys) {
            md.update(ba);
        }
        return md.digest();
    }

    public static byte[] generateSHA1(byte[] ... keys) {
        return LocalDBUtils.generateSHA1(Arrays.asList(keys));
    }

    public static byte[] encodeBigDecimal(BigDecimal value) {
        int signum = value.signum();
        if (signum == 0) {
            byte[] result = new byte[]{-128};
            return result;
        }
        value = value.abs().stripTrailingZeros();
        int scale = value.scale();
        int exponent = value.precision() - scale;
        int appendZero = exponent % 2 == 1 || exponent % 2 == -1 ? 1 : 0;
        exponent += appendZero;
        String mantissaStr = value.scaleByPowerOfTen(scale).toBigInteger().toString(10);
        int mantissaStrLength = mantissaStr.length() + appendZero;
        int byteArrayLengthWithoutExponent = (mantissaStrLength + 1) / 2;
        byte[] byteArray = null;
        if (byteArrayLengthWithoutExponent < 20 && signum == -1) {
            byteArray = new byte[byteArrayLengthWithoutExponent + 2];
            byteArray[byteArrayLengthWithoutExponent + 1] = 102;
        } else {
            byteArray = new byte[byteArrayLengthWithoutExponent + 1];
        }
        byteArray[0] = (byte)(192 + exponent / 2);
        if (signum == -1) {
            byteArray[0] = ~byteArray[0];
        }
        boolean appendedZero = false;
        int mantissaIndex = 0;
        while (mantissaIndex < mantissaStr.length()) {
            int byteArrayIndex = (mantissaIndex + appendZero) / 2 + 1;
            if (appendZero == 1 && mantissaIndex == 0 && !appendedZero) {
                byteArray[byteArrayIndex] = 0;
                appendedZero = true;
                --mantissaIndex;
            } else if ((mantissaIndex + appendZero) % 2 == 0) {
                byteArray[byteArrayIndex] = (byte)((byte)(mantissaStr.charAt(mantissaIndex) - 48) * 10);
            } else {
                int n = byteArrayIndex;
                byteArray[n] = (byte)(byteArray[n] + (mantissaStr.charAt(mantissaIndex) - 48));
            }
            if ((mantissaIndex + appendZero) % 2 == 1 || mantissaIndex == mantissaStr.length() - 1) {
                if (signum == -1) {
                    byteArray[byteArrayIndex] = (byte)(101 - byteArray[byteArrayIndex]);
                } else {
                    int n = byteArrayIndex;
                    byteArray[n] = (byte)(byteArray[n] + 1);
                }
            }
            ++mantissaIndex;
        }
        return byteArray;
    }

    public static int compareUnsignedByteArrays(byte[] ba1, byte[] ba2) {
        int minByteArrSize = Math.min(ba1.length, ba2.length);
        int j = 0;
        while (j < minByteArrSize) {
            int cmp = LocalDBUtils.compareUnsignedBytes(ba1[j], ba2[j]);
            if (cmp != 0) {
                return cmp;
            }
            ++j;
        }
        if (ba1.length > ba2.length) {
            return 1;
        }
        if (ba1.length < ba2.length) {
            return -1;
        }
        return 0;
    }

    public static int compareUnsignedBytes(byte b1, byte b2) {
        if ((char)b1 > (char)b2) {
            return 1;
        }
        if ((char)b1 < (char)b2) {
            return -1;
        }
        return 0;
    }

    public static void setLog4jToUtilsLogging(String name) {
    }
}

