/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.maven.plugins.android.phase01generatesources;

import com.android.builder.core.VariantConfiguration;
import com.android.builder.internal.SymbolLoader;
import com.android.builder.internal.SymbolWriter;
import com.android.utils.ILogger;
import com.google.common.collect.ArrayListMultimap;
import com.jayway.maven.plugins.android.phase01generatesources.GenerateSourcesMojo;
import com.jayway.maven.plugins.android.phase01generatesources.MavenILogger;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

final class ResourceClassGenerator {
    private final GenerateSourcesMojo mojo;
    private final File targetDirectory;
    private final File genDirectory;
    private final Log log;
    private final ILogger androidUtilsLog;

    public ResourceClassGenerator(GenerateSourcesMojo mojo, File targetDirectory, File genDirectory) {
        this.mojo = mojo;
        this.targetDirectory = targetDirectory;
        this.genDirectory = genDirectory;
        this.log = mojo.getLog();
        this.androidUtilsLog = new MavenILogger(this.log);
    }

    public void generateLibraryRs(Set<Artifact> libraries, String libraryType) throws MojoExecutionException {
        ArrayListMultimap libMap = ArrayListMultimap.create();
        for (Artifact lib : libraries) {
            File unpackedLibDirectory = this.mojo.getUnpackedLibFolder(lib);
            File rFile = new File(unpackedLibDirectory, "R.txt");
            if (!rFile.isFile()) continue;
            File libManifestFile = new File(unpackedLibDirectory, "AndroidManifest.xml");
            String packageName = VariantConfiguration.getManifestPackage((File)libManifestFile);
            this.log.debug((CharSequence)("Reading R for " + packageName + " at " + rFile));
            SymbolLoader libSymbols = this.loadSymbols(rFile);
            libMap.put((Object)packageName, (Object)libSymbols);
        }
        if (libMap.isEmpty()) {
            return;
        }
        File projectR = new File(this.targetDirectory, "R.txt");
        SymbolLoader fullSymbolValues = this.loadSymbols(projectR);
        for (String packageName : libMap.keySet()) {
            this.log.info((CharSequence)("Generating R file for " + libraryType + " : " + packageName));
            Collection symbols = libMap.get((Object)packageName);
            SymbolWriter writer = new SymbolWriter(this.genDirectory.getAbsolutePath(), packageName, fullSymbolValues);
            for (SymbolLoader symbolLoader : symbols) {
                writer.addSymbolsToWrite(symbolLoader);
            }
            this.writeSymbols(writer, packageName);
        }
    }

    private SymbolLoader loadSymbols(File file) throws MojoExecutionException {
        SymbolLoader libSymbols = new SymbolLoader(file, this.androidUtilsLog);
        try {
            libSymbols.load();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load " + file, (Exception)e);
        }
        return libSymbols;
    }

    private void writeSymbols(SymbolWriter writer, String packageName) throws MojoExecutionException {
        try {
            writer.write();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write R for " + packageName, (Exception)e);
        }
    }
}

