/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro.kafka;

import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.serdes.Utils;
import com.hortonworks.registries.schemaregistry.serdes.avro.AvroSnapshotDeserializer;
import com.hortonworks.registries.schemaregistry.serdes.avro.MessageAndMetadata;
import com.hortonworks.registries.schemaregistry.serdes.avro.MessageAndMetadataAvroDeserializer;
import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.ExtendedDeserializer;

public class KafkaAvroDeserializer
implements ExtendedDeserializer<Object> {
    public static final String READER_VERSIONS = "schemaregistry.reader.schema.versions";
    private boolean isKey;
    private Map<String, Integer> readerVersions;
    private final AvroSnapshotDeserializer avroSnapshotDeserializer;
    private final MessageAndMetadataAvroDeserializer messageAndMetadataAvroDeserializer;
    private String keySchemaVersionIdHeaderName;
    private String valueSchemaVersionIdHeaderName;

    public KafkaAvroDeserializer() {
        this.avroSnapshotDeserializer = new AvroSnapshotDeserializer();
        this.messageAndMetadataAvroDeserializer = new MessageAndMetadataAvroDeserializer();
    }

    public KafkaAvroDeserializer(ISchemaRegistryClient schemaRegistryClient) {
        this.avroSnapshotDeserializer = new AvroSnapshotDeserializer(schemaRegistryClient);
        this.messageAndMetadataAvroDeserializer = new MessageAndMetadataAvroDeserializer(schemaRegistryClient);
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.isKey = isKey;
        this.keySchemaVersionIdHeaderName = Utils.getOrDefault(configs, "key_schema_version_id_header_name", "key.schema.version.id");
        if (this.keySchemaVersionIdHeaderName == null || this.keySchemaVersionIdHeaderName.isEmpty()) {
            throw new IllegalArgumentException("keySchemaVersionIdHeaderName should not be null or empty");
        }
        this.valueSchemaVersionIdHeaderName = Utils.getOrDefault(configs, "value_schema_version_id_header_name", "value.schema.version.id");
        if (this.valueSchemaVersionIdHeaderName == null || this.valueSchemaVersionIdHeaderName.isEmpty()) {
            throw new IllegalArgumentException("valueSchemaVersionIdHeaderName should not be null or empty");
        }
        Map versions = (Map)configs.get(READER_VERSIONS);
        this.readerVersions = versions != null ? versions : Collections.emptyMap();
        this.avroSnapshotDeserializer.init(configs);
        this.messageAndMetadataAvroDeserializer.init(configs);
    }

    public Object deserialize(String topic, byte[] data) {
        return this.avroSnapshotDeserializer.deserialize(new ByteArrayInputStream(data), this.readerVersions.get(topic));
    }

    public Object deserialize(String topic, Headers headers, byte[] data) {
        Header header;
        if (headers != null && (header = headers.lastHeader(this.isKey ? this.keySchemaVersionIdHeaderName : this.valueSchemaVersionIdHeaderName)) != null) {
            return this.messageAndMetadataAvroDeserializer.deserialize(new MessageAndMetadata(header.value(), data), this.readerVersions.get(topic));
        }
        return this.deserialize(topic, data);
    }

    public void close() {
        try {
            Utils.closeAll(new AutoCloseable[]{this.avroSnapshotDeserializer, this.messageAndMetadataAvroDeserializer});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

