/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.exceptions.RegistryException;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serdes.avro.AbstractAvroSnapshotDeserializer;
import com.hortonworks.registries.schemaregistry.serdes.avro.MessageAndMetadata;
import com.hortonworks.registries.schemaregistry.serdes.avro.SerDesProtocolHandlerRegistry;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroException;
import java.io.ByteArrayInputStream;

public class MessageAndMetadataAvroDeserializer
extends AbstractAvroSnapshotDeserializer<MessageAndMetadata> {
    public MessageAndMetadataAvroDeserializer() {
    }

    public MessageAndMetadataAvroDeserializer(ISchemaRegistryClient schemaRegistryClient) {
        super(schemaRegistryClient);
    }

    public Object deserialize(MessageAndMetadata context, Integer readerSchemaVersion) throws SerDesException {
        SchemaMetadata schemaMetadata;
        SchemaVersionInfo schemaVersionInfo;
        byte protocolId = this.retrieveProtocolId(context);
        SchemaIdVersion schemaIdVersion = this.retrieveSchemaIdVersion(protocolId, context);
        try {
            schemaVersionInfo = this.schemaRegistryClient.getSchemaVersionInfo(schemaIdVersion);
            schemaMetadata = this.schemaRegistryClient.getSchemaMetadataInfo(schemaVersionInfo.getName()).getSchemaMetadata();
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        return this.doDeserialize(context, protocolId, schemaMetadata, schemaVersionInfo.getVersion(), readerSchemaVersion);
    }

    protected Object doDeserialize(MessageAndMetadata context, byte protocolId, SchemaMetadata schemaMetadata, Integer writerSchemaVersion, Integer readerSchemaVersion) throws SerDesException {
        return this.buildDeserializedObject(protocolId, new ByteArrayInputStream(context.payload()), schemaMetadata, writerSchemaVersion, readerSchemaVersion);
    }

    protected byte retrieveProtocolId(MessageAndMetadata context) throws SerDesException {
        byte[] metadata = context.metadata();
        byte protocolId = metadata[0];
        this.checkProtocolHandlerExists(protocolId);
        return protocolId;
    }

    private void checkProtocolHandlerExists(byte protocolId) {
        if (SerDesProtocolHandlerRegistry.get().getSerDesProtocolHandler(protocolId) == null) {
            throw new AvroException("Unknown protocol id [" + protocolId + "] received while de-serializing the header");
        }
    }

    protected SchemaIdVersion retrieveSchemaIdVersion(byte protocolId, MessageAndMetadata context) throws SerDesException {
        byte[] metadata = context.metadata();
        return SerDesProtocolHandlerRegistry.get().getSerDesProtocolHandler(protocolId).handleSchemaVersionDeserialization(new ByteArrayInputStream(metadata, 1, metadata.length));
    }
}

