/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.SchemaMetadata;
import com.hortonworks.registries.schemaregistry.SchemaVersionInfo;
import com.hortonworks.registries.schemaregistry.SchemaVersionKey;
import com.hortonworks.registries.schemaregistry.SchemaVersionRetriever;
import com.hortonworks.registries.schemaregistry.avro.AvroSchemaResolver;
import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import com.hortonworks.registries.schemaregistry.exceptions.RegistryException;
import com.hortonworks.registries.schemaregistry.serde.AbstractSnapshotDeserializer;
import com.hortonworks.registries.schemaregistry.serde.SerDesException;
import com.hortonworks.registries.schemaregistry.serdes.SerDesProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.SerDesProtocolHandlerRegistry;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAvroSnapshotDeserializer<I>
extends AbstractSnapshotDeserializer<I, Object, Schema> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAvroSnapshotDeserializer.class);
    public static final String SPECIFIC_AVRO_READER = "specific.avro.reader";
    private AvroSchemaResolver avroSchemaResolver;
    protected boolean useSpecificAvroReader = false;

    public AbstractAvroSnapshotDeserializer() {
    }

    public AbstractAvroSnapshotDeserializer(ISchemaRegistryClient schemaRegistryClient) {
        super(schemaRegistryClient);
    }

    public void doInit(Map<String, ?> config) {
        super.doInit(config);
        SchemaVersionRetriever schemaVersionRetriever = this.createSchemaVersionRetriever();
        this.avroSchemaResolver = new AvroSchemaResolver(schemaVersionRetriever);
        this.useSpecificAvroReader = (Boolean)this.getValue(config, SPECIFIC_AVRO_READER, false);
    }

    private SchemaVersionRetriever createSchemaVersionRetriever() {
        return new SchemaVersionRetriever(){

            public SchemaVersionInfo retrieveSchemaVersion(SchemaVersionKey key) throws SchemaNotFoundException {
                return AbstractAvroSnapshotDeserializer.this.schemaRegistryClient.getSchemaVersionInfo(key);
            }

            public SchemaVersionInfo retrieveSchemaVersion(SchemaIdVersion key) throws SchemaNotFoundException {
                return AbstractAvroSnapshotDeserializer.this.schemaRegistryClient.getSchemaVersionInfo(key);
            }
        };
    }

    protected Schema getParsedSchema(SchemaVersionKey schemaVersionKey) throws InvalidSchemaException, SchemaNotFoundException {
        return new Schema.Parser().parse(this.avroSchemaResolver.resolveSchema(schemaVersionKey));
    }

    protected Object buildDeserializedObject(byte protocolId, InputStream payloadInputStream, SchemaMetadata schemaMetadata, Integer writerSchemaVersion, Integer readerSchemaVersion) throws SerDesException {
        String schemaName = schemaMetadata.getName();
        SchemaVersionKey writerSchemaVersionKey = new SchemaVersionKey(schemaName, writerSchemaVersion);
        LOG.debug("SchemaKey: [{}] for the received payload", (Object)writerSchemaVersionKey);
        Schema writerSchema = (Schema)this.getSchema(writerSchemaVersionKey);
        if (writerSchema == null) {
            throw new RegistryException("No schema exists with metadata-key: " + schemaMetadata + " and writerSchemaVersion: " + writerSchemaVersion);
        }
        Schema readerSchema = readerSchemaVersion != null ? (Schema)this.getSchema(new SchemaVersionKey(schemaName, readerSchemaVersion)) : null;
        return this.deserializePayloadForProtocol(protocolId, payloadInputStream, writerSchema, readerSchema);
    }

    protected Object deserializePayloadForProtocol(byte protocolId, InputStream payloadInputStream, Schema writerSchema, Schema readerSchema) throws SerDesException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(SPECIFIC_AVRO_READER, this.useSpecificAvroReader);
        props.put("writer.schema", writerSchema);
        props.put("reader.schema", readerSchema);
        SerDesProtocolHandler serDesProtocolHandler = SerDesProtocolHandlerRegistry.get().getSerDesProtocolHandler(protocolId);
        return serDesProtocolHandler.handlePayloadDeserialization(payloadInputStream, props);
    }
}

