/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serdes.avro;

import com.hortonworks.registries.schemaregistry.SchemaIdVersion;
import com.hortonworks.registries.schemaregistry.serdes.SerDesProtocolHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.AvroSerDesHandler;
import com.hortonworks.registries.schemaregistry.serdes.avro.exceptions.AvroRetryableException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;

public abstract class AbstractAvroSerDesProtocolHandler
implements SerDesProtocolHandler {
    public static final String WRITER_SCHEMA = "writer.schema";
    public static final String READER_SCHEMA = "reader.schema";
    private final AvroSerDesHandler avroSerDesHandler;
    protected final Byte protocolId;

    protected AbstractAvroSerDesProtocolHandler(Byte protocolId, AvroSerDesHandler avroSerDesHandler) {
        this.protocolId = protocolId;
        this.avroSerDesHandler = avroSerDesHandler;
    }

    @Override
    public void handleSchemaVersionSerialization(OutputStream outputStream, SchemaIdVersion schemaIdVersion) {
        try {
            outputStream.write(new byte[]{this.protocolId});
            this.doHandleSchemaVersionSerialization(outputStream, schemaIdVersion);
        }
        catch (IOException e) {
            throw new AvroRetryableException(e);
        }
    }

    protected abstract void doHandleSchemaVersionSerialization(OutputStream var1, SchemaIdVersion var2) throws IOException;

    @Override
    public Byte getProtocolId() {
        return this.protocolId;
    }

    @Override
    public void handlePayloadSerialization(OutputStream outputStream, Object input) {
        this.avroSerDesHandler.handlePayloadSerialization(outputStream, input);
    }

    @Override
    public Object handlePayloadDeserialization(InputStream payloadInputStream, Map<String, Object> context) {
        boolean useSpecificAvroReader = (Boolean)context.getOrDefault("specific.avro.reader", false);
        Schema writerSchema = (Schema)context.get(WRITER_SCHEMA);
        Schema readerSchema = (Schema)context.get(READER_SCHEMA);
        return this.avroSerDesHandler.handlePayloadDeserialization(payloadInputStream, writerSchema, readerSchema, useSpecificAvroReader);
    }
}

