/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.avro;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hortonworks.registries.schemaregistry.SchemaResolver;
import com.hortonworks.registries.schemaregistry.SchemaVersionKey;
import com.hortonworks.registries.schemaregistry.SchemaVersionRetriever;
import com.hortonworks.registries.schemaregistry.errors.CyclicSchemaDependencyException;
import com.hortonworks.registries.schemaregistry.errors.InvalidSchemaException;
import com.hortonworks.registries.schemaregistry.errors.SchemaNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class AvroSchemaResolver
implements SchemaResolver {
    private final SchemaVersionRetriever schemaVersionRetriever;

    public AvroSchemaResolver(SchemaVersionRetriever schemaVersionRetriever) {
        this.schemaVersionRetriever = schemaVersionRetriever;
    }

    @Override
    public String resolveSchema(SchemaVersionKey schemaVersionKey) throws InvalidSchemaException, SchemaNotFoundException {
        HashMap<String, SchemaParsingState> schemaParsingStates = new HashMap<String, SchemaParsingState>();
        schemaParsingStates.put(schemaVersionKey.getSchemaName(), SchemaParsingState.PARSING);
        return this.getResultantSchema(schemaVersionKey, schemaParsingStates);
    }

    @Override
    public String resolveSchema(String schemaText) throws InvalidSchemaException, SchemaNotFoundException {
        HashMap<String, SchemaParsingState> schemaParsingStates = new HashMap<String, SchemaParsingState>();
        return this.getResultantSchema(schemaText, schemaParsingStates);
    }

    private String getResultantSchema(SchemaVersionKey schemaVersionKey, Map<String, SchemaParsingState> schemaParsingStates) throws InvalidSchemaException, SchemaNotFoundException {
        String schemaText = this.schemaVersionRetriever.retrieveSchemaVersion(schemaVersionKey).getSchemaText();
        return this.getResultantSchema(schemaText, schemaParsingStates);
    }

    private String getResultantSchema(String schemaText, Map<String, SchemaParsingState> schemaParsingStates) throws InvalidSchemaException, SchemaNotFoundException {
        Map<String, Schema> complexTypes = this.traverseIncludedSchemaTypes(schemaText, schemaParsingStates);
        Schema.Parser parser = new Schema.Parser();
        parser.addTypes(complexTypes);
        Schema schema = parser.parse(schemaText);
        HashSet<String> visitingTypes = new HashSet<String>();
        Schema updatedSchema = this.handleUnionFieldsWithNull(schema, visitingTypes);
        return schema == updatedSchema && complexTypes.isEmpty() ? schemaText : updatedSchema.toString();
    }

    public Schema handleUnionFieldsWithNull(Schema schema, Set<String> visitingTypes) {
        if (visitingTypes.contains(schema.getFullName())) {
            return schema;
        }
        visitingTypes.add(schema.getFullName());
        Schema updatedRootSchema = schema;
        if (schema.getType() == Schema.Type.RECORD) {
            List fields = updatedRootSchema.getFields();
            ArrayList<Schema.Field> updatedFields = new ArrayList<Schema.Field>(fields.size());
            boolean hasUnionType = false;
            for (Schema.Field field : fields) {
                boolean currentFieldTypeIsUnion;
                Schema fieldSchema = field.schema();
                boolean bl = currentFieldTypeIsUnion = fieldSchema.getType() == Schema.Type.UNION;
                if (currentFieldTypeIsUnion) {
                    if (((Schema)fieldSchema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                        hasUnionType = true;
                    }
                } else {
                    Schema updatedFieldSchema = this.handleUnionFieldsWithNull(fieldSchema, visitingTypes);
                    if (fieldSchema != updatedFieldSchema) {
                        hasUnionType = true;
                    }
                }
                updatedFields.add(new Schema.Field(field.name(), fieldSchema, field.doc(), (JsonNode)(currentFieldTypeIsUnion ? NullNode.getInstance() : field.defaultValue()), field.order()));
            }
            if (hasUnionType) {
                updatedRootSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
                updatedRootSchema.setFields(updatedFields);
                for (String string : schema.getAliases()) {
                    updatedRootSchema.addAlias(string);
                }
                for (Map.Entry entry : schema.getJsonProps().entrySet()) {
                    updatedRootSchema.addProp((String)entry.getKey(), (JsonNode)entry.getValue());
                }
            }
        }
        return updatedRootSchema;
    }

    private Schema updateUnionFields(Schema schema) {
        Schema updatedSchema = schema;
        List fields = schema.getFields();
        boolean hasUnionType = false;
        ArrayList<Schema.Field> updatedFields = new ArrayList<Schema.Field>(fields.size());
        for (Schema.Field field : fields) {
            Schema fieldSchema = field.schema();
            Schema.Field updatedField = field;
            if (fieldSchema.getType() == Schema.Type.UNION && ((Schema)fieldSchema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                updatedField = new Schema.Field(field.name(), fieldSchema, field.doc(), (JsonNode)NullNode.getInstance(), field.order());
                hasUnionType = true;
            }
            updatedFields.add(updatedField);
        }
        if (hasUnionType) {
            updatedSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
            updatedSchema.setFields(updatedFields);
            for (String string : schema.getAliases()) {
                updatedSchema.addAlias(string);
            }
            for (Map.Entry entry : schema.getJsonProps().entrySet()) {
                updatedSchema.addProp((String)entry.getKey(), (JsonNode)entry.getValue());
            }
        }
        return updatedSchema;
    }

    private Map<String, Schema> traverseIncludedSchemaTypes(String schemaText, Map<String, SchemaParsingState> schemaParsingStates) throws InvalidSchemaException, SchemaNotFoundException {
        List<SchemaVersionKey> includedSchemaVersions = this.getIncludedSchemaVersions(schemaText);
        if (includedSchemaVersions == null || includedSchemaVersions.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Schema> schemaTypes = new HashMap<String, Schema>();
        for (SchemaVersionKey schemaVersionKey : includedSchemaVersions) {
            Map<String, Schema> collectedSchemas = this.collectSchemaTypes(schemaVersionKey, schemaParsingStates);
            if (collectedSchemas == null) continue;
            schemaTypes.putAll(collectedSchemas);
        }
        return schemaTypes;
    }

    private Map<String, Schema> collectSchemaTypes(SchemaVersionKey schemaVersionKey, Map<String, SchemaParsingState> schemaParsingStates) throws SchemaNotFoundException, InvalidSchemaException {
        String schemaName = schemaVersionKey.getSchemaName();
        SchemaParsingState schemaParsingState = schemaParsingStates.putIfAbsent(schemaName, SchemaParsingState.PARSING);
        if (SchemaParsingState.PARSED == schemaParsingState) {
            return null;
        }
        if (SchemaParsingState.PARSING == schemaParsingState) {
            throw new CyclicSchemaDependencyException("Cyclic dependency of schema imports with schema [" + schemaName + "]");
        }
        if (schemaParsingState == null) {
            Schema.Parser parser = new Schema.Parser();
            Schema schema = parser.parse(this.getResultantSchema(schemaVersionKey, schemaParsingStates));
            HashMap<String, Schema> complexTypes = new HashMap<String, Schema>();
            this.collectComplexTypes(schema, complexTypes);
            schemaParsingStates.put(schemaName, SchemaParsingState.PARSED);
            return complexTypes;
        }
        throw new IllegalStateException("Schema parsing with schema version " + schemaVersionKey + " is in invalid state!!");
    }

    private void collectComplexTypes(Schema schema, Map<String, Schema> complexTypes) {
        switch (schema.getType()) {
            case RECORD: {
                complexTypes.put(schema.getFullName(), schema);
                List fields = schema.getFields();
                for (Schema.Field field : fields) {
                    Schema fieldSchema = field.schema();
                    this.collectComplexTypes(fieldSchema, complexTypes);
                }
                break;
            }
            case ARRAY: {
                complexTypes.put(schema.getFullName(), schema);
                this.collectComplexTypes(schema.getElementType(), complexTypes);
                break;
            }
            case UNION: {
                complexTypes.put(schema.getFullName(), schema);
                List unionSchemas = schema.getTypes();
                for (Schema schemaEntry : unionSchemas) {
                    this.collectComplexTypes(schemaEntry, complexTypes);
                }
                break;
            }
            case MAP: {
                complexTypes.put(schema.getFullName(), schema);
                this.collectComplexTypes(schema.getValueType(), complexTypes);
                break;
            }
        }
    }

    private List<SchemaVersionKey> getIncludedSchemaVersions(String schemaText) throws InvalidSchemaException {
        com.fasterxml.jackson.databind.JsonNode jsonNode = null;
        try {
            jsonNode = new ObjectMapper().readTree(schemaText);
        }
        catch (IOException e) {
            throw new InvalidSchemaException(e);
        }
        com.fasterxml.jackson.databind.JsonNode includeSchemaNodes = jsonNode.get("includeSchemas");
        ArrayList<SchemaVersionKey> includedSchemaVersions = new ArrayList<SchemaVersionKey>();
        if (includeSchemaNodes != null) {
            if (!includeSchemaNodes.isArray()) {
                throw new InvalidSchemaException("includeSchemas should be an array of strings");
            }
            for (com.fasterxml.jackson.databind.JsonNode includeSchema : includeSchemaNodes) {
                String name = includeSchema.get("name").asText();
                com.fasterxml.jackson.databind.JsonNode versionNode = includeSchema.get("version");
                int version = versionNode != null ? versionNode.asInt() : SchemaVersionKey.LATEST_VERSION.intValue();
                includedSchemaVersions.add(new SchemaVersionKey(name, version));
            }
        }
        return includedSchemaVersions;
    }

    private static enum SchemaParsingState {
        PARSING,
        PARSED;

    }
}

