/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.serde;

import com.hortonworks.registries.schemaregistry.client.ISchemaRegistryClient;
import com.hortonworks.registries.schemaregistry.client.SchemaRegistryClient;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerDes {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSerDes.class);
    protected ISchemaRegistryClient schemaRegistryClient;
    protected boolean initialized = false;
    protected boolean closed = false;

    public AbstractSerDes() {
        this(null);
    }

    public AbstractSerDes(ISchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = schemaRegistryClient;
    }

    public final void init(Map<String, ?> config) {
        if (this.closed) {
            throw new IllegalStateException("Closed instance can not be initialized again");
        }
        if (this.initialized) {
            LOG.info("This instance [{}] is already inited", (Object)this);
            return;
        }
        LOG.debug("Initialized with config: [{}]", config);
        if (this.schemaRegistryClient == null) {
            this.schemaRegistryClient = new SchemaRegistryClient(config);
        }
        this.doInit(config);
        this.initialized = true;
    }

    protected void doInit(Map<String, ?> config) {
    }

    public void close() throws Exception {
        if (this.closed) {
            LOG.info("This instance [{}] is already closed", (Object)this);
            return;
        }
        try {
            if (this.schemaRegistryClient != null) {
                this.schemaRegistryClient.close();
            }
        }
        finally {
            this.closed = true;
        }
    }
}

