/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.schemaregistry.client;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.hortonworks.registries.schemaregistry.client.AbstractUrlSelector;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class LoadBalancedFailoverUrlSelector
extends AbstractUrlSelector {
    public static final String FAILED_URL_EXPIRY_INTERVAL_MS = "failed.url.expiry.interval.ms";
    private Cache<String, Boolean> failedUrls;
    private AtomicInteger index = new AtomicInteger();

    public LoadBalancedFailoverUrlSelector(String clusterUrl) {
        super(clusterUrl);
    }

    @Override
    public void init(Map<String, Object> conf) {
        super.init(conf);
        this.failedUrls = CacheBuilder.newBuilder().expireAfterWrite(((Long)conf.getOrDefault(FAILED_URL_EXPIRY_INTERVAL_MS, 300000L)).longValue(), TimeUnit.MILLISECONDS).build();
    }

    @Override
    public String select() {
        int i;
        String url = null;
        while (!this.index.compareAndSet(i = this.index.get(), (i + 1) % this.urls.length) || this.failedUrls.getIfPresent((Object)(url = this.urls[i])) != null) {
        }
        return url;
    }

    @Override
    public void urlWithError(String url, Exception e) {
        if (this.failedError(e)) {
            this.failedUrls.put((Object)url, (Object)true);
            if (this.failedUrls.size() == (long)this.urls.length) {
                this.failedUrls.invalidateAll();
            }
        }
    }

    protected boolean failedError(Exception ex) {
        return true;
    }
}

