/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.entities.LabelError;
import com.herbocailleau.sgq.entities.Zone;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class LabelErrorAction
extends SgqActionSupport {
    private static final long serialVersionUID = 3074255662512738956L;
    private static final Log log = LogFactory.getLog(LabelErrorAction.class);
    protected List<LabelError> productionErrors;
    protected List<LabelError> expeditionErrors;
    protected String labelErrorId;
    protected String replayLine;
    protected String comment;
    protected boolean editAction;
    protected boolean deleteAction;

    public List<LabelError> getProductionErrors() {
        return this.productionErrors;
    }

    public List<LabelError> getExpeditionErrors() {
        return this.expeditionErrors;
    }

    public void setLabelErrorId(String labelErrorId) {
        this.labelErrorId = labelErrorId;
    }

    public void setReplayLine(String replayLine) {
        this.replayLine = replayLine;
    }

    public void setEditAction(boolean editAction) {
        this.editAction = editAction;
    }

    public void setDeleteAction(boolean deleteAction) {
        this.deleteAction = deleteAction;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String input() throws Exception {
        ProductionService productionService = (ProductionService)this.newService(ProductionService.class);
        this.productionErrors = productionService.getLabelErrorsForZone(Zone.ZE);
        this.expeditionErrors = productionService.getLabelErrorsForZone(Zone.ZP);
        return super.input();
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "label-error"})})
    public String execute() throws Exception {
        String result;
        block9: {
            result = "success";
            if (this.editAction || this.deleteAction) {
                if (StringUtils.isBlank((CharSequence)this.comment)) {
                    this.addActionError("Le commentaire est obligatoire");
                    result = this.input();
                } else {
                    ProductionService productionService = (ProductionService)this.newService(ProductionService.class);
                    try {
                        if (this.editAction) {
                            ImportLog importLog = productionService.replayError(this.labelErrorId, this.replayLine, this.comment);
                            if (importLog.isError()) {
                                this.addActionError(importLog.getMessage());
                                result = this.input();
                            }
                            break block9;
                        }
                        productionService.deleteError(this.labelErrorId, this.comment);
                    }
                    catch (Exception ex) {
                        if (log.isErrorEnabled()) {
                            log.error((Object)"Can't edit or delete line", (Throwable)ex);
                        }
                        this.addActionError(ex.getMessage());
                        result = this.input();
                    }
                }
            } else {
                result = this.input();
            }
        }
        return result;
    }
}

