<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Préparation des analyzes</title>
    </head>
    <body>
        <h1>Préparation des analyses</h1>

		<fieldset>
			<legend>Filtre</legend>
			<form method="get">
                <s:actionerror />
                <table class="filter">
                    <tr>
                        <th>Premier num&eacute;ro de lot :</th>
                        <td><input type="text" name="startNumber"
                            <s:if test="startNumber != 0">
                                value="<s:property value="startNumber" />"
                            </s:if> />
                        </td>
                    </tr>
                    <tr>
                        <th>Dernier num&eacute;ro de lot :</th>
                        <td><input type="text" name="endNumber"
                            <s:if test="endNumber != 0">
                                value="<s:property value="endNumber" />"
                            </s:if> />
                        </td>
                    </tr>
                    <tr>
                        <td colspan="2"><input type="submit" value="Valider" /></td>
                    </tr>
                </table>
	        </form>
		</fieldset>

        <s:if test="batches != null">
            <h3>Préparation:</h3>
            
            <s:form action="analyze-prepare" namespace='/user' method="post">
    	        <table class="listing">
    	            <tr>
    	                <th>Lot</th>
    	                <th>Plante</th>
                        <th>Fournisseur</th>
                        <th title="Quantité rentrée">Quantité</th>
                        <s:iterator value="analyzeCategories">
                          <th><s:property value="name" /></th>
                        </s:iterator>
    	            </tr>
                    <s:iterator value="batches" var="batch">
                        <tr>
                            <s:hidden name="batchIds" value="%{topiaId}" />
                            <td>
                              <a href="<s:url action='batch-view' namespace='/user'>
                                  <s:param name="batchId"><s:property value="topiaId" /></s:param>
                              </s:url>"><s:property value="number" /></a></td>
                            <td><a href="<s:url action='batch-view' namespace='/user'>
                                <s:param name="batchId"><s:property value="topiaId" /></s:param>
                              </s:url>"><s:property value="product.name" /></a></td>
                            <td><s:property value="supplier.name" /></td>
                            <td><s:property value="quantity" />
                              <s:property value="getProductUnit(product)" /></td>
                            <s:iterator value="analyzeCategories" var="itCategories">
                            <td>
                                <s:iterator value="#batch.product.analyzeType" var="itAnalyzeType">
                                    <s:if test='analyzeCategory == #itCategories'>
                                        <input name="analyzeType.<s:property value="#batch.topiaId" />"
                                            type="checkbox" value="<s:property value="topiaId" />">
                                        <s:property value="name" />
                                        <s:set var="analyze" value="existingAnalyzes.get(#batch, #itAnalyzeType)"/>
                                        <s:if test='#analyze != null'>
                                            <s:if test="#analyze.sentDate == null">
                                              <span title="Analyse déjà prévue à la date <s:text name="sgq.web.common.dateformat"></span>
                                                <s:param value="#analyze.creationDate"/>
                                              </s:text>">*</span>
                                            </s:if>
                                            <s:elseif test="#analyze.receiptDate == null">
                                              <span title="Analyse en cours depuis le <s:text name="sgq.web.common.dateformat"></span>
                                                <s:param value="#analyze.sentDate"/>
                                              </s:text>">*</span>
                                            </s:elseif>
                                            <s:else>
                                              <span title="Analyse déjà effectuée">*</span>
                                            </s:else>
                                        </s:if>
                                        <br />
                                    </s:if>
                                </s:iterator>
                            </td>
                            </s:iterator>
                        </tr>
                    </s:iterator>
    	        </table>
                <s:if test="!existingAnalyzes.isEmpty()">
                  <div>
                    <em>* : Analyse déjà demandée ou effectuée pour le lot (survoler * pour plus d'information)</em>
                  </div>
                </s:if>
    	        <input type="submit" value="Valider la préparation" />
            </s:form>
        </s:if>
    </body>
</html>
