/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.SgqBusinessConfig;
import com.herbocailleau.sgq.business.services.ConfigurationService;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class BatchReceiveLimit
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 4211084787152505568L;
    protected ConfigurationService configurationService;
    protected int nextNonBioBatchNumber;
    protected int lastNonBioBatchNumber;
    protected int nextBioBatchNumber;
    protected int lastBioBatchNumber;

    public void prepare() throws Exception {
        this.configurationService = (ConfigurationService)this.newService(ConfigurationService.class);
    }

    public int getNextNonBioBatchNumber() {
        return this.nextNonBioBatchNumber;
    }

    public void setNextNonBioBatchNumber(int nextNonBioBatchNumber) {
        this.nextNonBioBatchNumber = nextNonBioBatchNumber;
    }

    public int getNextBioBatchNumber() {
        return this.nextBioBatchNumber;
    }

    public void setNextBioBatchNumber(int nextBioBatchNumber) {
        this.nextBioBatchNumber = nextBioBatchNumber;
    }

    public int getLastNonBioBatchNumber() {
        return this.lastNonBioBatchNumber;
    }

    public int getLastBioBatchNumber() {
        return this.lastBioBatchNumber;
    }

    public String input() throws Exception {
        this.nextNonBioBatchNumber = this.configurationService.getNextNonBioBatchNumber();
        this.nextBioBatchNumber = this.configurationService.getNextBioBatchNumber();
        this.lastNonBioBatchNumber = this.configurationService.getLastNonBioBatchNumber();
        this.lastBioBatchNumber = this.configurationService.getLastBioBatchNumber();
        return "input";
    }

    public void validate() {
        SgqBusinessConfig config = this.getConfig();
        if (this.nextNonBioBatchNumber < config.getBatchRangeNonBioStart()) {
            this.addActionError("Le numero de lot pour les plantes conventionnelle\u2009ne peut pas \u00eatre inf\u00e9rieur \u00e0 " + config.getBatchRangeNonBioStart());
        }
        if (this.nextBioBatchNumber < config.getBatchRangeBioStart()) {
            this.addActionError("Le numero de lot pour les plantes conventionnelle\u2009ne peut pas \u00eatre inf\u00e9rieur \u00e0 " + config.getBatchRangeBioStart());
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "batch-receive-view"})})
    public String execute() throws Exception {
        this.configurationService.saveBatchLimit(this.nextNonBioBatchNumber, this.nextBioBatchNumber);
        return "success";
    }
}

