/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.BatchAnalyzeImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.util.Date;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class BatchAnalyzeEditAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 3074255662512738956L;
    protected BatchService batchService;
    protected ReferentialService referentialService;
    protected String batchId;
    protected List<AnalyzeType> analyzeTypes;
    protected Batch batch;
    protected String analyzeTypeId;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public void prepare() throws Exception {
        this.batchService = (BatchService)this.newService(BatchService.class);
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
    }

    public String input() throws Exception {
        this.batch = this.batchService.getBatchById(this.batchId);
        this.analyzeTypes = this.referentialService.findAllAnalyzeTypes();
        return "input";
    }

    public Batch getBatch() {
        return this.batch;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return this.analyzeTypes;
    }

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "batch-view", "batchId", "${batch.topiaId}"})})
    public String execute() throws Exception {
        this.batch = this.batchService.getBatchById(this.batchId);
        AnalyzeType analyzeType = this.referentialService.findAnalyzeTypeById(this.analyzeTypeId);
        BatchAnalyzeImpl analyze = new BatchAnalyzeImpl();
        analyze.setBatch(this.batch);
        analyze.setAnalyzeType(analyzeType);
        analyze.setCreationDate(new Date());
        this.batchService.saveAnalyze((BatchAnalyze)analyze);
        return "success";
    }
}

