/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.services.ConfigurationService;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;

@InterceptorRefs(value={@InterceptorRef(value="defaultStack"), @InterceptorRef(value="execAndWait", params={"excludeMethods", "input"})})
public class BackupRunAction
extends SgqActionSupport {
    private static final long serialVersionUID = -8074981655886378100L;
    protected Map<String, String> devices;
    protected String deviceId;
    protected String notificationEmail;

    public String input() throws Exception {
        this.loadData();
        return "input";
    }

    protected void loadData() {
        try {
            ConfigurationService configurationService = (ConfigurationService)this.newService(ConfigurationService.class);
            this.devices = configurationService.getBackupDevices();
        }
        catch (SgqBusinessException ex) {
            this.addActionError(ex.getMessage());
        }
    }

    public Map<String, String> getDevices() {
        return this.devices;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getNotificationEmail() {
        return this.notificationEmail;
    }

    public void setNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.deviceId)) {
            this.addActionError("Le choix du p\u00e9ripherique est obligatoire !");
        }
        if (StringUtils.isEmpty((CharSequence)this.notificationEmail)) {
            this.addActionError("L'email de notification est obligatoire !");
        } else if (!this.notificationEmail.toUpperCase().matches("[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,4}")) {
            this.addActionError("L'email de notification n'est pas valide !");
        }
        if (this.hasActionErrors()) {
            this.loadData();
        }
    }

    public String execute() throws Exception {
        ConfigurationService configurationService = (ConfigurationService)this.newService(ConfigurationService.class);
        configurationService.saveBackupOnDevice(this.deviceId, this.notificationEmail);
        return "success";
    }
}

