/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web;

import com.herbocailleau.sgq.business.ServiceFactory;
import com.herbocailleau.sgq.business.SgqBusinessConfig;
import com.herbocailleau.sgq.business.SgqService;
import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.entities.Product;
import com.opensymphony.xwork2.ActionSupport;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts2.interceptor.ParameterAware;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.PagerBean;
import org.nuiton.util.PagerBeanUtil;
import org.nuiton.web.filter.TopiaTransactionFilter;

public class SgqActionSupport
extends ActionSupport
implements ServletRequestAware,
ParameterAware {
    private static final long serialVersionUID = -2556887628485541765L;
    public static final int ITEM_PER_PAGE = 20;
    protected TopiaContext transaction;
    protected Map<String, String[]> actionParameters;

    public void setServletRequest(HttpServletRequest request) {
        this.transaction = TopiaTransactionFilter.getTransaction((ServletRequest)request);
    }

    public void setParameters(Map<String, String[]> actionParameters) {
        this.actionParameters = actionParameters;
    }

    public <E extends SgqService> E newService(Class<E> serviceClass) {
        SgqService service = ServiceFactory.newService(serviceClass, (TopiaContext)this.transaction);
        return (E)service;
    }

    public SgqBusinessConfig getConfig() {
        return ServiceFactory.getConfig();
    }

    public String getParameter(String parameterKey) {
        String[] parameterValues;
        String result = null;
        if (this.actionParameters != null && (parameterValues = (String[])this.actionParameters.get(parameterKey)) != null && parameterValues.length >= 1) {
            result = parameterValues[0];
        }
        return result;
    }

    public String[] getParameters(String parameterKey) {
        String[] result = null;
        if (this.actionParameters != null) {
            result = (String[])this.actionParameters.get(parameterKey);
        }
        return result;
    }

    public String getProductUnit(Product product) {
        return SgqUtils.getProductUnit((SgqBusinessConfig)this.getConfig(), (Product)product);
    }

    protected PagerBean getPager(int page, int itemPerPage, long totalCount) {
        PagerBean bean = new PagerBean();
        bean.setPageIndex(page);
        bean.setPagesNumber(PagerBeanUtil.getTotalPage((long)((int)totalCount), (int)itemPerPage));
        bean.setRecords(totalCount);
        return bean;
    }
}

