/*
 * #%L
 * SGQ :: Web
 * $Id: PlaceListAction.java 171 2012-10-19 16:52:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.0/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/PlaceListAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class PlaceListAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 7464265806217949750L;

    protected List<Place> places;

    @Override
    public String execute() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        places = referentialService.getPlaces();
        return SUCCESS;
    }

    public List<Place> getPlaces() {
        return places;
    }
}
