/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.BatchModel;
import com.herbocailleau.sgq.business.model.SearchModel;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.PagerBean;

public class SearchAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SearchAction.class);
    protected ReferentialService referentialService;
    protected SearchModel search;
    protected List<BatchModel> batchModels;
    protected List<ProductStatus> productStatuses;
    protected List<String> productCategories;
    protected PagerBean pager;
    protected int page;

    public SearchModel getSearch() {
        if (this.search == null) {
            this.search = new SearchModel();
        }
        return this.search;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void prepare() throws Exception {
        String dateEnd;
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        String[] productStatusIds = this.getParameters("search.productStatusId");
        ArrayList<ProductStatus> productStatus = new ArrayList<ProductStatus>();
        if (productStatusIds != null) {
            for (String productStatusId : productStatusIds) {
                productStatus.add(this.referentialService.getProductStatusById(productStatusId));
            }
        }
        this.getSearch().setProductStatus(productStatus);
        String dateBegin = this.getParameter("search.beginDate");
        if (StringUtils.isNotBlank((CharSequence)dateBegin)) {
            this.getSearch().setBeginDate(SgqUtils.parseSgqDate((String)dateBegin));
        }
        if (StringUtils.isNotBlank((CharSequence)(dateEnd = this.getParameter("search.endDate")))) {
            this.getSearch().setEndDate(SgqUtils.parseSgqDate((String)dateEnd));
        }
    }

    public String execute() throws Exception {
        this.productStatuses = this.referentialService.findAllProductStatus();
        this.productCategories = this.referentialService.findAllProductCategories();
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        Pair searchResult = batchService.searchBatch(this.getSearch(), this.page * 20, 20);
        this.batchModels = (List)searchResult.getKey();
        long totalCount = (Long)searchResult.getValue();
        this.pager = this.getPager(this.page, 20, totalCount);
        return "success";
    }

    public List<BatchModel> getBatchModels() {
        return this.batchModels;
    }

    public List<ProductStatus> getProductStatuses() {
        return this.productStatuses;
    }

    public List<String> getProductCategories() {
        return this.productCategories;
    }

    public PagerBean getPager() {
        return this.pager;
    }

    @Action(value="search-export", results={@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String export() throws Exception {
        return "success";
    }

    public InputStream getInputStream() {
        InputStream result;
        block2: {
            BatchService batchService = (BatchService)this.newService(BatchService.class);
            result = null;
            try {
                result = batchService.searchBatchASCsv(this.search);
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get csv stream", (Throwable)ex);
            }
        }
        return result;
    }

    public String getFilename() {
        return "search.csv";
    }
}

