/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientsImportAction
extends SgqActionSupport {
    private static final long serialVersionUID = -4395441064634702753L;
    private static final Log log = LogFactory.getLog(ClientsImportAction.class);
    protected File file;
    protected List<ImportLog<Client>> importLogs;

    public void setFile(File file) {
        this.file = file;
    }

    public String execute() throws Exception {
        ReferentialService referentialService = (ReferentialService)this.newService(ReferentialService.class);
        String result = super.execute();
        try {
            this.importLogs = referentialService.importClients(this.file);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import client file", (Throwable)ex);
            }
            this.addActionError(ex.getMessage());
            result = this.input();
        }
        return result;
    }

    public List<ImportLog<Client>> getImportLogs() {
        return this.importLogs;
    }
}

