/*
 * #%L
 * SGQ :: Web
 * $Id: BatchImportAction.java 151 2012-10-10 09:03:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchImportAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.File;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'import de reception des lots.
 * 
 * @author echatellier
 */
public class BatchImportAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    private static final Log log = LogFactory.getLog(BatchImportAction.class);

    protected long batchsCount;

    protected int nextNonBioBatchNumber;

    protected int nextBioBatchNumber;

    protected File file;

    protected List<ImportLog<Batch>> importLogs;

    @Override
    public String input() throws Exception {

        BatchService batchService = newService(BatchService.class);
        batchsCount = batchService.getBatchCount();
        nextNonBioBatchNumber = batchService.getNextNonBioBatchNumber();
        nextBioBatchNumber = batchService.getNextBioBatchNumber();

        return super.input();
    }

    public long getBatchsCount() {
        return batchsCount;
    }

    public int getNextNonBioBatchNumber() {
        return nextNonBioBatchNumber;
    }

    public int getNextBioBatchNumber() {
        return nextBioBatchNumber;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String execute() throws Exception {
        String result = SUCCESS;
        if (file == null) {
            result = input();
        } else {
            BatchService batchService = newService(BatchService.class);
            try {
                importLogs = batchService.importBatchFile(file);
            } catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't import batch file", ex);
                }
                addActionError(ex.getMessage());
                result = input();
            }
        }

        return result;
    }
    
    public List<ImportLog<Batch>> getImportLogs() {
        return importLogs;
    }
}
