/*
 * #%L
 * SGQ :: Web
 * $Id: AnalyzesPrepareProcessAction.java 77 2012-09-19 16:32:29Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/AnalyzesPrepareProcessAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.List;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de preparation des analyses pour plusieurs lots.
 * 
 * @author echatellier
 */
public class AnalyzesPrepareProcessAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected List<String> batchIds;

    protected ReferentialService referentialService;

    protected BatchService batchService;

    protected Batch batch;

    public void setBatchIds(List<String> batchIds) {
        this.batchIds = batchIds;
    }

    @Override
    public void validate() {

        referentialService = newService(ReferentialService.class);
        batchService = newService(BatchService.class);

        if (batchIds == null) {
            addActionError("Aucun identifiant de lots fournit");
        }
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "analyzes-dashboard!input"})})
    public String execute() throws Exception {

        for (String batchId : batchIds) {
            Batch batch = batchService.getBatchById(batchId);

            String[] analyzeTypeIds = getParameters("analyzeType." + batch.getTopiaId());
            if (analyzeTypeIds != null) {
                for (String analyzeTypeId : analyzeTypeIds) {
                    AnalyzeType analyzeType = referentialService.findAnalyzeTypeById(analyzeTypeId);
                    batchService.prepareAnalyze(batch, analyzeType);
                }
            }
        }

        return SUCCESS;
    }
}
