/*
 * #%L
 * SGQ :: Web
 * $Id: ProductAction.java 105 2012-09-28 14:22:53Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ProductAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductImpl;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;

public class ProductAction extends SgqActionSupport implements Preparable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5564446302091087009L;

    protected ReferentialService referentialService;

    protected String productId;

    protected Product product;

    protected List<ProductStatus> status;

    protected List<AnalyzeType> analyzeTypes;

    public void setProductId(String productId) {
        this.productId = productId;
    }

    @Override
    public void prepare() throws Exception {
        referentialService = newService(ReferentialService.class);
        status = referentialService.findAllProductStatus();
        analyzeTypes = referentialService.findAllAnalyzeTypes();
    }

    public List<ProductStatus> getStatus() {
        return status;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return analyzeTypes;
    }

    protected List<String> productStatusIds;

    protected String productStatusName;

    protected List<String> analyzeTypeIds;

    public void setProductStatusIds(List<String> productStatusIds) {
        this.productStatusIds = productStatusIds;
    }

    public void setProductStatusName(String productStatusName) {
        this.productStatusName = productStatusName;
    }

    public void setAnalyzeTypeIds(List<String> analyzeTypeIds) {
        this.analyzeTypeIds = analyzeTypeIds;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName" , "products"})})
    public String execute() throws Exception {

        product.getProductStatus().clear();
        for (String productStatusId : productStatusIds) {
            product.addProductStatus(referentialService.getProductStatusById(productStatusId));
        }

        product.getAnalyzeType().clear();
        for (String analyzeTypeId : analyzeTypeIds) {
            product.addAnalyzeType(referentialService.findAnalyzeTypeById(analyzeTypeId));
        }

        referentialService.saveProduct(product, productStatusName);

        return SUCCESS;
    }

    public Product getProduct() {
        if (product == null) {
            String productId = getParameter("productId");
            if (StringUtils.isNotBlank(productId)) {
                product = referentialService.getProductById(productId);
            } else {
                product = new ProductImpl();
            }
        }
        return product;
    }
}
