/*
 * #%L
 * SGQ :: Web
 * $Id: ClientsImportAction.java 151 2012-10-10 09:03:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ClientsImportAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.io.File;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class ClientsImportAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4395441064634702753L;

    private static final Log log = LogFactory.getLog(ClientsImportAction.class);

    protected File file;

    protected List<ImportLog<Client>> importLogs;
    
    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String execute() throws Exception {
        ReferentialService referentialService = newService(ReferentialService.class);

        String result = super.execute();
        try {
            importLogs = referentialService.importClients(file);
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import client file", ex);
            }
            addActionError(ex.getMessage());
            result = input();
        }

        return result;
    }
    
    public List<ImportLog<Client>> getImportLogs() {
        return importLogs;
    }
}
