/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.business.model;

import com.herbocailleau.sgq.business.model.SearchColumn;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Country;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.entities.SynthesisMention;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SearchModel {
    protected String query;
    protected String client;
    protected Country origin;
    protected String supplier;
    protected List<ProductStatus> productStatus;
    protected List<String> productCategories;
    protected List<AnalyzeType> analyzeTypes;
    protected boolean analyzeTypeOrOperator;
    protected DateType dateType;
    protected Date beginDate;
    protected Date endDate;
    protected SynthesisMention synthesisMention;
    protected List<SearchColumn> searchColumns = new ArrayList<SearchColumn>();
    protected ExpiredType expired;

    public SearchModel() {
        for (SearchColumn searchColumn : SearchColumn.values()) {
            if (!searchColumn.isDefaultSelected()) continue;
            this.searchColumns.add(searchColumn);
        }
        this.expired = ExpiredType.NON_EXPIRED;
    }

    public SearchModel(String query) {
        this();
        this.query = query;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public Country getOrigin() {
        return this.origin;
    }

    public void setOrigin(Country origin) {
        this.origin = origin;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public List<ProductStatus> getProductStatus() {
        return this.productStatus;
    }

    public void setProductStatus(List<ProductStatus> productStatus) {
        this.productStatus = productStatus;
    }

    public List<String> getProductCategories() {
        return this.productCategories;
    }

    public void setProductCategories(List<String> productCategories) {
        this.productCategories = productCategories;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return this.analyzeTypes;
    }

    public void setAnalyzeTypes(List<AnalyzeType> analyzeTypes) {
        this.analyzeTypes = analyzeTypes;
    }

    public boolean isAnalyzeTypeOrOperator() {
        return this.analyzeTypeOrOperator;
    }

    public void setAnalyzeTypeOrOperator(boolean analyzeTypeOrOperator) {
        this.analyzeTypeOrOperator = analyzeTypeOrOperator;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public SynthesisMention getSynthesisMention() {
        return this.synthesisMention;
    }

    public void setSynthesisMention(SynthesisMention synthesisMention) {
        this.synthesisMention = synthesisMention;
    }

    public List<SearchColumn> getSearchColumns() {
        return this.searchColumns;
    }

    public void setSearchColumns(List<SearchColumn> searchColumns) {
        this.searchColumns = searchColumns;
    }

    public ExpiredType getExpired() {
        return this.expired;
    }

    public void setExpired(ExpiredType expired) {
        this.expired = expired;
    }

    public static enum ExpiredType {
        NON_EXPIRED,
        EXPIRED,
        ALL;

    }

    public static enum DateType {
        ENTRY_DATE,
        DLUO,
        DMES,
        DPMES,
        DMESD,
        EXPIRED_DATE;

    }
}

