package com.herbocailleau.sgq.entities;

import com.herbocailleau.sgq.SGQDAOHelper.SGQEntityEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class AnalyzeTypeDAOAbstract<E extends AnalyzeType> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)AnalyzeType.class;
    }

    @Override
    public SGQEntityEnum getTopiaEntityEnum() {
        return SGQEntityEnum.AnalyzeType;
    }

    @Override
    public void delete(E entity) throws TopiaException {
                                        {
                                        List<BatchAnalyze> list = getContext()
                                                    .getDAO(BatchAnalyze.class)
                                                    .findAllByProperties(BatchAnalyze.PROPERTY_ANALYZE_TYPE, entity);
                                            for (BatchAnalyze item : list) {

                                                // sletellier : Set null only if target is concerned by deletion
                                                if (entity.equals(item.getAnalyzeType())) {
                                                    item.setAnalyzeType(null);
                                                }
                        
                    }
                }

        super.delete(entity);
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(AnalyzeType.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(AnalyzeType.PROPERTY_NAME, v);
        return result;
    }

    public E findByDurationDays(int v) throws TopiaException {
        E result = findByProperty(AnalyzeType.PROPERTY_DURATION_DAYS, v);
        return result;
    }

    public List<E> findAllByDurationDays(int v) throws TopiaException {
        List<E> result = findAllByProperty(AnalyzeType.PROPERTY_DURATION_DAYS, v);
        return result;
    }

    public E findByAnalyzeCategory(AnalyzeCategory v) throws TopiaException {
        E result = findByProperty(AnalyzeType.PROPERTY_ANALYZE_CATEGORY, v);
        return result;
    }

    public List<E> findAllByAnalyzeCategory(AnalyzeCategory v) throws TopiaException {
        List<E> result = findAllByProperty(AnalyzeType.PROPERTY_ANALYZE_CATEGORY, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == BatchAnalyze.class) {
            BatchAnalyzeDAO dao = (BatchAnalyzeDAO)
                getContext().getDAO(BatchAnalyze.class);
            tmp = dao.findAllByAnalyzeType(entity);
            result.addAll(tmp);
        }

        if (type == Product.class) {
            ProductDAO dao = (ProductDAO)
                getContext().getDAO(Product.class);
            tmp = dao.findAllContainsAnalyzeType(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);

        List<? extends TopiaEntity> list;

        list = findUsages(BatchAnalyze.class, entity);
        if (!list.isEmpty()) {
            result.put(BatchAnalyze.class, list);
        }

        list = findUsages(Product.class, entity);
        if (!list.isEmpty()) {
            result.put(Product.class, list);
        }

        return result;
    }

} //AnalyzeTypeDAOAbstract<E extends AnalyzeType>
