/*
 * #%L
 * SGQ :: Business
 * $Id: SearchModel.java 142 2012-10-08 14:35:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-business/src/main/java/com/herbocailleau/sgq/business/model/SearchModel.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.business.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.herbocailleau.sgq.entities.Country;
import com.herbocailleau.sgq.entities.ProductStatus;

public class SearchModel {

    public enum DateType {
        ENTRY_DATE, DLUO, DMES, DPMES, DMESD, EXPIRED_DATE
    }

    protected String query;

    protected String client;

    protected Country origin;
    
    protected String supplier;

    protected List<ProductStatus> productStatus;

    protected List<String> productCategories;

    protected DateType dateType;

    protected Date beginDate;

    protected Date endDate;

    protected List<SearchColumn> searchColumns;

    protected boolean expired;

    public SearchModel() {
        // init columns with default selected ones
        searchColumns = new ArrayList<SearchColumn>();
        for (SearchColumn searchColumn : SearchColumn.values()) {
            if (searchColumn.isDefaultSelected()) {
                searchColumns.add(searchColumn);
            }
        }
    }

    public SearchModel(String query) {
        this();
        this.query = query;
    }

    public String getQuery() {
        return query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getClient() {
        return client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public Country getOrigin() {
        return origin;
    }

    public void setOrigin(Country origin) {
        this.origin = origin;
    }

    public String getSupplier() {
        return supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public List<ProductStatus> getProductStatus() {
        return productStatus;
    }

    public void setProductStatus(List<ProductStatus> productStatus) {
        this.productStatus = productStatus;
    }

    public List<String> getProductCategories() {
        return productCategories;
    }

    public void setProductCategories(List<String> productCategories) {
        this.productCategories = productCategories;
    }

    public DateType getDateType() {
        return dateType;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public List<SearchColumn> getSearchColumns() {
        return searchColumns;
    }

    public void setSearchColumns(List<SearchColumn> searchColumns) {
        this.searchColumns = searchColumns;
    }

    public boolean isExpired() {
        return expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }
}
