package com.herbocailleau.sgq;

import com.herbocailleau.sgq.entities.AnalyzeCategory;
import com.herbocailleau.sgq.entities.AnalyzeCategoryDAO;
import com.herbocailleau.sgq.entities.AnalyzeFile;
import com.herbocailleau.sgq.entities.AnalyzeFileDAO;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.AnalyzeTypeDAO;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.BatchAnalyzeDAO;
import com.herbocailleau.sgq.entities.BatchDAO;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.entities.ClientDAO;
import com.herbocailleau.sgq.entities.Expedition;
import com.herbocailleau.sgq.entities.ExpeditionDAO;
import com.herbocailleau.sgq.entities.Place;
import com.herbocailleau.sgq.entities.PlaceDAO;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.entities.PresentationDAO;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.entities.ProductDAO;
import com.herbocailleau.sgq.entities.ProductPlace;
import com.herbocailleau.sgq.entities.ProductPlaceDAO;
import com.herbocailleau.sgq.entities.ProductStatus;
import com.herbocailleau.sgq.entities.ProductStatusDAO;
import com.herbocailleau.sgq.entities.Production;
import com.herbocailleau.sgq.entities.ProductionDAO;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.entities.SupplierDAO;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

public class SGQDAOHelper {

    public enum SGQEntityEnum implements TopiaEntityEnum {
        AnalyzeCategory(AnalyzeCategory.class, ArrayUtils.EMPTY_STRING_ARRAY),
        AnalyzeFile(AnalyzeFile.class, ArrayUtils.EMPTY_STRING_ARRAY),
        AnalyzeType(AnalyzeType.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Batch(Batch.class, new String[]{ "number" }, "number"),
        BatchAnalyze(BatchAnalyze.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Client(Client.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Expedition(Expedition.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Place(Place.class, new String[]{ "code" }, "code"),
        Presentation(Presentation.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Product(Product.class, ArrayUtils.EMPTY_STRING_ARRAY),
        ProductPlace(ProductPlace.class, ArrayUtils.EMPTY_STRING_ARRAY),
        ProductStatus(ProductStatus.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Production(Production.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Supplier(Supplier.class, new String[]{ "code" }, "code");

        /**
         * The contract of the entity.
         */
        protected Class<? extends TopiaEntity> contract;

        /**
         * The fully qualified name of the implementation of the entity.
         */
        protected String implementationFQN;

        /**
         * The implementation class of the entity (will be lazy computed at runtime).
         */
        protected Class<? extends TopiaEntity> implementation;

        /**
         * The array of property involved in the natural key of the entity.
         */
        protected String[] naturalIds;

        /**
         * The array of not null properties of the entity.
         */
        protected String[] notNulls;

        SGQEntityEnum(Class<? extends TopiaEntity > contract, String[] notNulls, String... naturalIds)     {
        this.contract = contract;
        this.notNulls = notNulls;
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        @Override
        public String[] getNaturalIds()     {
        return naturalIds;
        }

        @Override
        public boolean isUseNaturalIds()     {
        return naturalIds.length > 0;
        }

        @Override
        public String[] getNotNulls()     {
        return notNulls;
        }

        @Override
        public boolean isUseNotNulls()     {
        return notNulls.length > 0;
        }

        @Override
        public String getImplementationFQN()     {
        return implementationFQN;
        }

        @Override
        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass)     {
        return SGQDAOHelper.getContractClass(klass) == contract;
        }

        @Override
        public Class<? extends TopiaEntity> getImplementation()     {
        if (implementation == null) {
        try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaRuntimeException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
        }

        public static SGQEntityEnum valueOf(TopiaEntity entity)     {
        return valueOf(entity.getClass());
        }

        public static SGQEntityEnum valueOf(Class<?> klass)     {
        if (klass.isInterface()) {
           return valueOf(klass.getSimpleName());
        }
        for (SGQEntityEnum entityEnum : SGQEntityEnum.values()) {
            if (entityEnum.getContract().isAssignableFrom(klass)) {
                //todo check it works for inheritance
                return entityEnum;
            }
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(SGQEntityEnum.values()));
        }

    } //SGQEntityEnum

    protected SGQDAOHelper() { }

    public static String getModelVersion() {
        return "";
    }

    public static String getModelName() {
        return "SGQ";
    }

    public static AnalyzeCategoryDAO getAnalyzeCategoryDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        AnalyzeCategoryDAO result = ci.getDAO(AnalyzeCategory.class, AnalyzeCategoryDAO.class);
        return result;
    }

    public static AnalyzeFileDAO getAnalyzeFileDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        AnalyzeFileDAO result = ci.getDAO(AnalyzeFile.class, AnalyzeFileDAO.class);
        return result;
    }

    public static AnalyzeTypeDAO getAnalyzeTypeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        AnalyzeTypeDAO result = ci.getDAO(AnalyzeType.class, AnalyzeTypeDAO.class);
        return result;
    }

    public static BatchDAO getBatchDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        BatchDAO result = ci.getDAO(Batch.class, BatchDAO.class);
        return result;
    }

    public static BatchAnalyzeDAO getBatchAnalyzeDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        BatchAnalyzeDAO result = ci.getDAO(BatchAnalyze.class, BatchAnalyzeDAO.class);
        return result;
    }

    public static ClientDAO getClientDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ClientDAO result = ci.getDAO(Client.class, ClientDAO.class);
        return result;
    }

    public static ExpeditionDAO getExpeditionDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ExpeditionDAO result = ci.getDAO(Expedition.class, ExpeditionDAO.class);
        return result;
    }

    public static PlaceDAO getPlaceDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PlaceDAO result = ci.getDAO(Place.class, PlaceDAO.class);
        return result;
    }

    public static PresentationDAO getPresentationDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PresentationDAO result = ci.getDAO(Presentation.class, PresentationDAO.class);
        return result;
    }

    public static ProductDAO getProductDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ProductDAO result = ci.getDAO(Product.class, ProductDAO.class);
        return result;
    }

    public static ProductPlaceDAO getProductPlaceDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ProductPlaceDAO result = ci.getDAO(ProductPlace.class, ProductPlaceDAO.class);
        return result;
    }

    public static ProductStatusDAO getProductStatusDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ProductStatusDAO result = ci.getDAO(ProductStatus.class, ProductStatusDAO.class);
        return result;
    }

    public static ProductionDAO getProductionDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ProductionDAO result = ci.getDAO(Production.class, ProductionDAO.class);
        return result;
    }

    public static SupplierDAO getSupplierDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SupplierDAO result = ci.getDAO(Supplier.class, SupplierDAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SGQEntityEnum constant = SGQEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        SGQEntityEnum constant = SGQEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        SGQEntityEnum constant = SGQEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        SGQEntityEnum constant = SGQEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        SGQEntityEnum[] values = SGQEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        SGQEntityEnum[] values = SGQEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static SGQEntityEnum[] getContracts() {
        return SGQEntityEnum.values();
    }

} //SGQDAOHelper
