package com.herbocailleau.sgq.entities;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

public abstract class AnalyzeFileAbstract extends TopiaEntityAbstract implements AnalyzeFile {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : data
     */
    protected Blob data;

    /**
     * Nom de l'attribut en BD : analyze
     */
    protected Analyze analyze;

    /**
     * Nom de l'attribut en BD : batch
     */
    protected Batch batch;

    private static final long serialVersionUID = 4121412929849603122L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_DATA, Blob.class, data);
        visitor.visit(this, PROPERTY_ANALYZE, Analyze.class, analyze);
        visitor.visit(this, PROPERTY_BATCH, Batch.class, batch);
        visitor.end(this);
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        fireOnPreWrite(PROPERTY_NAME, oldValue, name);
        this.name = name;
        fireOnPostWrite(PROPERTY_NAME, oldValue, name);
    }

    @Override
    public String getName() {
        fireOnPreRead(PROPERTY_NAME, name);
        String result = this.name;
        fireOnPostRead(PROPERTY_NAME, name);
        return result;
    }

    @Override
    public void setData(Blob data) {
        Blob oldValue = this.data;
        fireOnPreWrite(PROPERTY_DATA, oldValue, data);
        this.data = data;
        fireOnPostWrite(PROPERTY_DATA, oldValue, data);
    }

    @Override
    public Blob getData() {
        fireOnPreRead(PROPERTY_DATA, data);
        Blob result = this.data;
        fireOnPostRead(PROPERTY_DATA, data);
        return result;
    }

    @Override
    public void setAnalyze(Analyze analyze) {
        Analyze oldValue = this.analyze;
        fireOnPreWrite(PROPERTY_ANALYZE, oldValue, analyze);
        this.analyze = analyze;
        fireOnPostWrite(PROPERTY_ANALYZE, oldValue, analyze);
    }

    @Override
    public Analyze getAnalyze() {
        fireOnPreRead(PROPERTY_ANALYZE, analyze);
        Analyze result = this.analyze;
        fireOnPostRead(PROPERTY_ANALYZE, analyze);
        return result;
    }

    @Override
    public void setBatch(Batch batch) {
        Batch oldValue = this.batch;
        fireOnPreWrite(PROPERTY_BATCH, oldValue, batch);
        this.batch = batch;
        fireOnPostWrite(PROPERTY_BATCH, oldValue, batch);
    }

    @Override
    public Batch getBatch() {
        fireOnPreRead(PROPERTY_BATCH, batch);
        Batch result = this.batch;
        fireOnPostRead(PROPERTY_BATCH, batch);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //AnalyzeFileAbstract
